/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxy;
import org.apache.ignite.lang.IgniteAsyncSupport;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class TransactionEventProxyImpl
implements TransactionProxy,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "All operations changing transaction's params or state are restricted inside event listener. The only exception is setRollbackOnly(), use it in case transaction should be rolled back.";
    private IgniteUuid xid;
    private GridNearTxLocal tx;
    private TransactionProxy proxy;

    public TransactionEventProxyImpl() {
    }

    public TransactionEventProxyImpl(GridNearTxLocal tx) {
        assert (tx != null);
        this.tx = tx;
        this.xid = tx.xid();
    }

    @Override
    public IgniteUuid xid() {
        return this.xid;
    }

    @Override
    public UUID nodeId() {
        return this.tx().nodeId();
    }

    @Override
    public long threadId() {
        return this.tx().threadId();
    }

    @Override
    public long startTime() {
        return this.tx().startTime();
    }

    @Override
    public TransactionIsolation isolation() {
        return this.tx().isolation();
    }

    @Override
    public TransactionConcurrency concurrency() {
        return this.tx().concurrency();
    }

    @Override
    public boolean implicit() {
        return this.tx().implicit();
    }

    @Override
    public boolean isInvalidate() {
        return this.tx().isInvalidate();
    }

    @Override
    public TransactionState state() {
        return this.tx().state();
    }

    @Override
    public long timeout() {
        return this.tx().timeout();
    }

    @Override
    public long timeout(long timeout) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public boolean setRollbackOnly() {
        return this.tx().setRollbackOnly();
    }

    @Override
    public boolean isRollbackOnly() {
        return this.tx().isRollbackOnly();
    }

    @Override
    public void commit() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public IgniteFuture<Void> commitAsync() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void close() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void rollback() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public IgniteFuture<Void> rollbackAsync() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void resume() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    public void suspend() throws IgniteException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    @Override
    @Nullable
    public String label() {
        return this.tx().label();
    }

    @Override
    public IgniteAsyncSupport withAsync() {
        throw new UnsupportedOperationException("Operation deprecated.");
    }

    @Override
    public boolean isAsync() {
        throw new UnsupportedOperationException("Operation deprecated.");
    }

    @Override
    public <R> IgniteFuture<R> future() {
        throw new UnsupportedOperationException("Operation deprecated.");
    }

    private TransactionProxy tx() throws IgniteException {
        if (this.tx == null) {
            throw new IgniteException("Operation allowed only inside remote filter or inside local listener registered on originating node. Only xid() operation allowed in other case. ");
        }
        if (this.proxy == null) {
            this.proxy = this.tx.proxy();
        }
        return this.proxy;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.xid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid = (IgniteUuid)in.readObject();
    }
}

