/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class FastCrc {
    private static final ThreadLocal<CRC32> CRC = ThreadLocal.withInitial(CRC32::new);
    private final CRC32 crc = new CRC32();
    private int val;

    public FastCrc() {
        this.reset();
    }

    public void reset() {
        this.val = -1;
        this.crc.reset();
    }

    public int getValue() {
        return this.val;
    }

    public void update(ByteBuffer buf, int len) {
        this.val = FastCrc.calcCrc(this.crc, buf, len);
    }

    public static int calcCrc(ByteBuffer buf, int len) {
        CRC32 crcAlgo = CRC.get();
        int res = FastCrc.calcCrc(crcAlgo, buf, len);
        crcAlgo.reset();
        return res;
    }

    public static int calcCrc(File file) throws IOException {
        assert (!file.isDirectory()) : "CRC32 can't be calculated over directories";
        CRC32 algo = new CRC32();
        try (CheckedInputStream in = new CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), algo);){
            byte[] buf = new byte[1024];
            while (((InputStream)in).read(buf) != -1) {
            }
        }
        return ~((int)algo.getValue());
    }

    private static int calcCrc(CRC32 crcAlgo, ByteBuffer buf, int len) {
        int initLimit = buf.limit();
        buf.limit(buf.position() + len);
        crcAlgo.update(buf);
        buf.limit(initLimit);
        return ~((int)crcAlgo.getValue());
    }
}

