/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.error.code.generators;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite.internal.error.code.generators.GenericGenerator;
import org.apache.ignite.internal.error.code.processor.ErrorCodeGroupDescriptor;
import org.apache.ignite.internal.error.code.processor.ErrorCodeGroupProcessorException;

public class CppGenerator
extends GenericGenerator {
    private static final String SuffixToChop = "_ERR";

    public CppGenerator(ProcessingEnvironment processingEnvironment, String outFilePath) {
        super(processingEnvironment, outFilePath);
    }

    private void generateHeader() throws IOException {
        this.line("// THIS IS AUTO-GENERATED FILE. DO NOT EDIT.");
        this.line();
        this.line("#pragma once");
        this.line();
        this.line("#include <cstdint>");
        this.line();
    }

    private void generateEnum(String comment, String name, List<String> valueNames, List<Integer> values) throws IOException {
        if (valueNames.size() != values.size()) {
            throw new ErrorCodeGroupProcessorException("valueNames.size() != values.size()");
        }
        this.line(comment);
        this.line("enum class " + name + " : underlying_t {");
        for (int i = 0; i < valueNames.size(); ++i) {
            boolean last = i == valueNames.size() - 1;
            this.line(String.format("    %s = 0x%s%s", valueNames.get(i), Integer.toHexString(values.get(i)), last ? "" : ","));
        }
        this.line("};");
        this.line();
    }

    private void generateErrorCodeGroup(ErrorCodeGroupDescriptor descriptor, boolean lastGroup) throws IOException {
        Integer groupCode = descriptor.groupCode;
        this.line("    // " + descriptor.className + " group. Group code: " + descriptor.groupCode);
        for (int i = 0; i < descriptor.errorCodes.size(); ++i) {
            boolean lastInGroup = i == descriptor.errorCodes.size() - 1;
            ErrorCodeGroupDescriptor.ErrorCode ec = descriptor.errorCodes.get(i);
            String name = CppGenerator.composeName(ec.name);
            String code = Integer.toHexString(CppGenerator.composeCode(groupCode, ec.code));
            this.line(String.format("    %s = 0x%s%s", name, code, lastGroup && lastInGroup ? "" : ","));
            if (!lastInGroup || lastGroup) continue;
            this.line();
        }
    }

    private void generateErrorCodeEnumStart() throws IOException {
        this.line("// Error codes.");
        this.line("enum class code : underlying_t {");
    }

    private void generateErrorCodeEnumEnd() throws IOException {
        this.line("};");
        this.line();
    }

    @Override
    void generateFile(List<ErrorCodeGroupDescriptor> descriptors) throws IOException {
        this.generateHeader();
        this.line("namespace ignite {");
        this.line();
        this.line("namespace error {");
        this.line();
        this.line("using underlying_t = std::uint32_t;");
        this.line();
        this.line("static inline const std::uint32_t group_shift = 16;");
        this.line();
        this.generateEnum("// Error groups codes.", "group", descriptors.stream().map(d -> d.groupName).collect(Collectors.toList()), descriptors.stream().map(d -> d.groupCode).collect(Collectors.toList()));
        this.line("inline group get_group_by_error_code(const underlying_t code) {");
        this.line("    return group(code >> group_shift);");
        this.line("}");
        this.line();
        this.generateErrorCodeEnumStart();
        for (int i = 0; i < descriptors.size(); ++i) {
            this.generateErrorCodeGroup(descriptors.get(i), i == descriptors.size() - 1);
        }
        this.generateErrorCodeEnumEnd();
        this.line("} // namespace error");
        this.line();
        this.line("} // namespace ignite");
    }

    private static int composeCode(int groupCode, int errorCode) {
        return groupCode << 16 | errorCode;
    }

    private static String composeName(String name) {
        if (name.endsWith(SuffixToChop)) {
            return name.substring(0, name.length() - SuffixToChop.length());
        }
        return name;
    }
}

