/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.distributionzones.DataNodesMapSerializer;
import org.apache.ignite.internal.distributionzones.LogicalTopologySetSerializer;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.NodesAttributesSerializer;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.thread.StripedScheduledThreadPoolExecutor;
import org.apache.ignite.internal.util.ByteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DistributionZonesUtil {
    private static final String DISTRIBUTION_ZONE_PREFIX = "distributionZone.";
    private static final String DISTRIBUTION_ZONE_DATA_NODES_PREFIX = "distributionZone.dataNodes.";
    public static final String DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX = "distributionZone.dataNodes.value.";
    public static final byte[] DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX_BYTES = "distributionZone.dataNodes.value.".getBytes(StandardCharsets.UTF_8);
    private static final String DISTRIBUTION_ZONE_SCALE_UP_CHANGE_TRIGGER_PREFIX = "distributionZone.dataNodes.scaleUpChangeTrigger.";
    private static final String DISTRIBUTION_ZONE_SCALE_DOWN_CHANGE_TRIGGER_PREFIX = "distributionZone.dataNodes.scaleDownChangeTrigger.";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_PREFIX = "distributionZones.logicalTopology.";
    private static final String DISTRIBUTION_ZONES_NODES_ATTRIBUTES = "distributionZones.nodesAttributes";
    private static final String DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION = "distributionZones.recoverableStateRevision";
    private static final String DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY = "distributionZones.lastHandledTopology";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY = "distributionZones.logicalTopology.nodes";
    private static final String DISTRIBUTION_ZONES_VERSIONED_CONFIGURATION_VAULT = "vault.distributionZone.versionedConfiguration.";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION = "distributionZones.logicalTopology.version";
    private static final String DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID = "distributionZones.logicalTopology.clusterId";
    private static final String DISTRIBUTION_ZONES_TOPOLOGY_AUGMENTATION_PREFIX = "distributionZones.topologyAugmentation.";
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_KEY = new ByteArray("distributionZones.logicalTopology.nodes");
    private static final ByteArray DISTRIBUTION_ZONES_NODES_ATTRIBUTES_KEY = new ByteArray("distributionZones.nodesAttributes");
    private static final ByteArray DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION_KEY = new ByteArray("distributionZones.recoverableStateRevision");
    private static final ByteArray DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY_KEY = new ByteArray("distributionZones.lastHandledTopology");
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION_KEY = new ByteArray("distributionZones.logicalTopology.version");
    private static final ByteArray DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID_KEY = new ByteArray("distributionZones.logicalTopology.clusterId");
    private static final long INITIAL_TRIGGER_REVISION_VALUE = -1L;
    private static final ByteArray DISTRIBUTION_ZONES_DATA_NODES_KEY = new ByteArray("distributionZone.dataNodes.");
    public static final String PARTITION_DISTRIBUTION_RESET_TIMEOUT = "partitionDistributionResetTimeout";
    static final int PARTITION_DISTRIBUTION_RESET_TIMEOUT_DEFAULT_VALUE = 0;
    public static final String REBALANCE_RETRY_DELAY_MS = "rebalanceRetryDelay";
    public static final int REBALANCE_RETRY_DELAY_DEFAULT = 200;

    public static ByteArray zoneDataNodesKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX + zoneId);
    }

    public static ByteArray zoneDataNodesKey() {
        return new ByteArray(DISTRIBUTION_ZONE_DATA_NODES_VALUE_PREFIX_BYTES);
    }

    public static ByteArray zoneVersionedConfigurationKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONES_VERSIONED_CONFIGURATION_VAULT + zoneId);
    }

    public static ByteArray zonesLogicalTopologyPrefix() {
        return new ByteArray(DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_PREFIX);
    }

    public static ByteArray zoneScaleUpChangeTriggerKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_UP_CHANGE_TRIGGER_PREFIX + zoneId);
    }

    public static ByteArray zoneScaleDownChangeTriggerKey(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_DOWN_CHANGE_TRIGGER_PREFIX + zoneId);
    }

    public static ByteArray zonesLogicalTopologyKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_KEY;
    }

    public static ByteArray zonesLogicalTopologyVersionKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_VERSION_KEY;
    }

    public static ByteArray zonesLogicalTopologyClusterIdKey() {
        return DISTRIBUTION_ZONES_LOGICAL_TOPOLOGY_CLUSTER_ID_KEY;
    }

    public static ByteArray zonesDataNodesPrefix() {
        return DISTRIBUTION_ZONES_DATA_NODES_KEY;
    }

    public static ByteArray zonesNodesAttributes() {
        return DISTRIBUTION_ZONES_NODES_ATTRIBUTES_KEY;
    }

    public static ByteArray zonesRecoverableStateRevision() {
        return DISTRIBUTION_ZONES_RECOVERABLE_STATE_REVISION_KEY;
    }

    public static ByteArray zonesLastHandledTopology() {
        return DISTRIBUTION_ZONES_LAST_HANDLED_TOPOLOGY_KEY;
    }

    static ByteArray zoneTopologyAugmentation(int zoneId) {
        return new ByteArray(DISTRIBUTION_ZONES_TOPOLOGY_AUGMENTATION_PREFIX + zoneId);
    }

    static CompoundCondition conditionForZoneCreation(int zoneId) {
        return Conditions.and((Condition)Conditions.notExists((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId)), (Condition)Conditions.notTombstone((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId)));
    }

    static CompoundCondition conditionForRecoverableStateChanges(long revision) {
        return Conditions.or((Condition)Conditions.notExists((ByteArray)DistributionZonesUtil.zonesRecoverableStateRevision()), (Condition)Conditions.value((ByteArray)DistributionZonesUtil.zonesRecoverableStateRevision()).lt(ByteUtils.longToBytesKeepingOrder((long)revision)));
    }

    static SimpleCondition conditionForZoneRemoval(int zoneId) {
        return Conditions.exists((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId));
    }

    static CompoundCondition triggerScaleUpScaleDownKeysCondition(long scaleUpTriggerRevision, long scaleDownTriggerRevision, int zoneId) {
        SimpleCondition scaleUpCondition = scaleUpTriggerRevision != -1L ? Conditions.value((ByteArray)DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId)).eq(ByteUtils.longToBytesKeepingOrder((long)scaleUpTriggerRevision)) : Conditions.notExists((ByteArray)DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId));
        SimpleCondition scaleDownCondition = scaleDownTriggerRevision != -1L ? Conditions.value((ByteArray)DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId)).eq(ByteUtils.longToBytesKeepingOrder((long)scaleDownTriggerRevision)) : Conditions.notExists((ByteArray)DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId));
        return Conditions.and((Condition)scaleUpCondition, (Condition)scaleDownCondition);
    }

    static Update updateDataNodesAndScaleUpTriggerKey(int zoneId, long revision, byte[] nodes) {
        return Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId), (byte[])nodes), Operations.put((ByteArray)DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId), (byte[])ByteUtils.longToBytesKeepingOrder((long)revision))}).yield(true);
    }

    static Update updateDataNodesAndScaleDownTriggerKey(int zoneId, long revision, byte[] nodes) {
        return Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId), (byte[])nodes), Operations.put((ByteArray)DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId), (byte[])ByteUtils.longToBytesKeepingOrder((long)revision))}).yield(true);
    }

    static Update updateDataNodesAndTriggerKeys(int zoneId, long revision, byte[] nodes) {
        return Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId), (byte[])nodes), Operations.put((ByteArray)DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId), (byte[])ByteUtils.longToBytesKeepingOrder((long)revision)), Operations.put((ByteArray)DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId), (byte[])ByteUtils.longToBytesKeepingOrder((long)revision))}).yield(true);
    }

    static Update deleteDataNodesAndTriggerKeys(int zoneId, long revision) {
        return Operations.ops((Operation[])new Operation[]{Operations.remove((ByteArray)DistributionZonesUtil.zoneDataNodesKey(zoneId)), Operations.remove((ByteArray)DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId)), Operations.remove((ByteArray)DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId))}).yield(true);
    }

    static Update updateLogicalTopologyAndVersion(LogicalTopologySnapshot logicalTopology) {
        return DistributionZonesUtil.updateLogicalTopologyAndVersionAndMaybeClusterId(logicalTopology, false);
    }

    static Update updateLogicalTopologyAndVersionAndClusterId(LogicalTopologySnapshot logicalTopology) {
        return DistributionZonesUtil.updateLogicalTopologyAndVersionAndMaybeClusterId(logicalTopology, true);
    }

    private static Update updateLogicalTopologyAndVersionAndMaybeClusterId(LogicalTopologySnapshot logicalTopology, boolean updateClusterId) {
        Set<NodeWithAttributes> topologyFromCmg = logicalTopology.nodes().stream().map(n -> new NodeWithAttributes(n.name(), n.id(), n.userAttributes(), n.storageProfiles())).collect(Collectors.toSet());
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyVersionKey(), (byte[])ByteUtils.longToBytesKeepingOrder((long)logicalTopology.version())));
        operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyKey(), (byte[])LogicalTopologySetSerializer.serialize(topologyFromCmg)));
        if (updateClusterId) {
            operations.add(Operations.put((ByteArray)DistributionZonesUtil.zonesLogicalTopologyClusterIdKey(), (byte[])ByteUtils.uuidToBytes((UUID)logicalTopology.clusterId())));
        }
        return Operations.ops((Operation[])((Operation[])operations.toArray(Operation[]::new))).yield(true);
    }

    public static Set<Node> dataNodes(Map<Node, Integer> dataNodesMap) {
        return dataNodesMap.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Map<Node, Integer> toDataNodesMap(Set<Node> dataNodes) {
        HashMap<Node, Integer> dataNodesMap = new HashMap<Node, Integer>();
        dataNodes.forEach(n -> dataNodesMap.merge((Node)n, 1, Integer::sum));
        return dataNodesMap;
    }

    @Nullable
    public static Set<Node> parseDataNodes(byte[] dataNodesBytes) {
        return dataNodesBytes == null ? null : DistributionZonesUtil.dataNodes(DistributionZonesUtil.deserializeDataNodesMap(dataNodesBytes));
    }

    public static Map<Node, Integer> deserializeDataNodesMap(byte[] bytes) {
        return DataNodesMapSerializer.deserialize(bytes);
    }

    public static Set<NodeWithAttributes> deserializeLogicalTopologySet(byte[] bytes) {
        return LogicalTopologySetSerializer.deserialize(bytes);
    }

    public static Map<UUID, NodeWithAttributes> deserializeNodesAttributes(byte[] bytes) {
        return NodesAttributesSerializer.deserialize(bytes);
    }

    static Map<Node, Integer> extractDataNodes(Entry dataNodesEntry) {
        if (!dataNodesEntry.empty()) {
            return DistributionZonesUtil.deserializeDataNodesMap(dataNodesEntry.value());
        }
        return Collections.emptyMap();
    }

    static long extractChangeTriggerRevision(Entry revisionEntry) {
        if (!revisionEntry.empty()) {
            return ByteUtils.bytesToLongKeepingOrder((byte[])revisionEntry.value());
        }
        return -1L;
    }

    public static boolean filterNodeAttributes(Map<String, String> nodeAttributes, String filter) {
        if (filter.equals("$..*")) {
            return true;
        }
        Map<String, Object> convertedAttributes = nodeAttributes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            long res;
            try {
                res = Long.parseLong((String)e.getValue());
            }
            catch (NumberFormatException ignored) {
                return e.getValue();
            }
            return res;
        }));
        Configuration jsonPathCfg = new Configuration.ConfigurationBuilder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST}).build();
        List res = (List)JsonPath.using((Configuration)jsonPathCfg).parse(convertedAttributes).read(filter, new Predicate[0]);
        return !res.isEmpty();
    }

    public static boolean filterStorageProfiles(NodeWithAttributes node, List<CatalogStorageProfileDescriptor> zoneStorageProfiles) {
        if (node.storageProfiles() == null) {
            return false;
        }
        List zoneStorageProfilesNames = zoneStorageProfiles.stream().map(CatalogStorageProfileDescriptor::storageProfile).collect(Collectors.toList());
        return new HashSet<String>(node.storageProfiles()).containsAll(zoneStorageProfilesNames);
    }

    public static Set<String> filterDataNodes(Set<Node> dataNodes, CatalogZoneDescriptor zoneDescriptor, Map<UUID, NodeWithAttributes> nodesAttributes) {
        return dataNodes.stream().filter(n -> DistributionZonesUtil.filterNodeAttributes(((NodeWithAttributes)nodesAttributes.get(n.nodeId())).userAttributes(), zoneDescriptor.filter())).filter(n -> DistributionZonesUtil.filterStorageProfiles((NodeWithAttributes)nodesAttributes.get(n.nodeId()), zoneDescriptor.storageProfiles().profiles())).map(Node::nodeName).collect(Collectors.toSet());
    }

    public static List<StorageProfileParams> parseStorageProfiles(String storageProfiles) {
        List<String> items = Arrays.asList(storageProfiles.split("\\s*,\\s*"));
        return items.stream().map(p -> StorageProfileParams.builder().storageProfile(p).build()).collect(Collectors.toList());
    }

    static StripedScheduledThreadPoolExecutor createZoneManagerExecutor(int concurrencyLvl, NamedThreadFactory namedThreadFactory) {
        return new StripedScheduledThreadPoolExecutor(concurrencyLvl, (ThreadFactory)namedThreadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
    }

    public static List<CatalogTableDescriptor> findTablesByZoneId(int zoneId, int catalogVersion, CatalogService catalogService) {
        return catalogService.tables(catalogVersion).stream().filter(table -> table.zoneId() == zoneId).collect(Collectors.toList());
    }

    @TestOnly
    public static ByteArray zoneScaleUpChangeTriggerKeyPrefix() {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_UP_CHANGE_TRIGGER_PREFIX);
    }

    @TestOnly
    public static ByteArray zoneScaleDownChangeTriggerKeyPrefix() {
        return new ByteArray(DISTRIBUTION_ZONE_SCALE_DOWN_CHANGE_TRIGGER_PREFIX);
    }
}

