/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters;

import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.metrics.MetricProvider;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.exporters.MetricExporter;
import org.apache.ignite.internal.metrics.exporters.configuration.ExporterView;
import org.jetbrains.annotations.Nullable;

public abstract class BasicMetricExporter<CfgT extends ExporterView>
implements MetricExporter<CfgT> {
    private MetricProvider metricsProvider;
    private Supplier<UUID> clusterIdSupplier;
    private String nodeName;
    private CfgT configuration;

    @Override
    public void start(MetricProvider metricsProvider, CfgT configuration, Supplier<UUID> clusterIdSupplier, String nodeName) {
        this.metricsProvider = metricsProvider;
        this.configuration = configuration;
        this.clusterIdSupplier = clusterIdSupplier;
        this.nodeName = nodeName;
    }

    @Override
    public synchronized void reconfigure(@Nullable CfgT newVal) {
        this.configuration = newVal;
    }

    protected synchronized CfgT configuration() {
        return this.configuration;
    }

    protected final IgniteBiTuple<Map<String, MetricSet>, Long> metrics() {
        return this.metricsProvider.metrics();
    }

    protected final UUID clusterId() {
        return this.clusterIdSupplier.get();
    }

    protected final String nodeName() {
        return this.nodeName;
    }
}

