/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.sql.ColumnMetadataImpl;
import org.apache.ignite.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite.internal.sql.configuration.distributed.SqlDistributedConfiguration;
import org.apache.ignite.internal.sql.configuration.local.SqlLocalConfiguration;
import org.apache.ignite.internal.sql.engine.QueryCancel;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.kill.KillCommand;
import org.apache.ignite.internal.sql.engine.prepare.CacheKey;
import org.apache.ignite.internal.sql.engine.prepare.DdlPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainPlan;
import org.apache.ignite.internal.sql.engine.prepare.ExplainablePlan;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.KeyValueGetPlan;
import org.apache.ignite.internal.sql.engine.prepare.KeyValueModifyPlan;
import org.apache.ignite.internal.sql.engine.prepare.KillPlan;
import org.apache.ignite.internal.sql.engine.prepare.LazyResultSetMetadata;
import org.apache.ignite.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite.internal.sql.engine.prepare.ParameterMetadata;
import org.apache.ignite.internal.sql.engine.prepare.ParameterType;
import org.apache.ignite.internal.sql.engine.prepare.PlanId;
import org.apache.ignite.internal.sql.engine.prepare.PlannerHelper;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.PrepareService;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.prepare.SelectCountPlan;
import org.apache.ignite.internal.sql.engine.prepare.ValidationResult;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlSqlToCommandConverter;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteSelectCount;
import org.apache.ignite.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlKill;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Cloner;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.sql.engine.util.cache.Cache;
import org.apache.ignite.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite.internal.sql.metrics.SqlPlanCacheMetricSource;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.type.NativeTypeSpec;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.SchemaNotFoundException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class PrepareServiceImpl
implements PrepareService {
    private static final IgniteLogger LOG = Loggers.forClass(PrepareServiceImpl.class);
    private static final ResultSetMetadata DML_METADATA = new ResultSetMetadataImpl(List.of(new ColumnMetadataImpl("ROWCOUNT", ColumnType.INT64, -1, Integer.MIN_VALUE, false, null)));
    private static final ParameterMetadata EMPTY_PARAMETER_METADATA = new ParameterMetadata(Collections.emptyList());
    private static final long THREAD_TIMEOUT_MS = 60000L;
    private final UUID prepareServiceId = UUID.randomUUID();
    private final AtomicLong planIdGen = new AtomicLong();
    private final DdlSqlToCommandConverter ddlConverter;
    private final Cache<CacheKey, CompletableFuture<QueryPlan>> cache;
    private final String nodeName;
    private final long plannerTimeout;
    private final int plannerThreadCount;
    private final MetricManager metricManager;
    private final SqlPlanCacheMetricSource sqlPlanCacheMetricSource;
    private final SqlSchemaManager schemaManager;
    private volatile ThreadPoolExecutor planningPool;

    public static PrepareServiceImpl create(String nodeName, CacheFactory cacheFactory, DataStorageManager dataStorageManager, MetricManager metricManager, SqlDistributedConfiguration clusterCfg, SqlLocalConfiguration nodeCfg, SqlSchemaManager schemaManager) {
        return new PrepareServiceImpl(nodeName, (Integer)clusterCfg.planner().estimatedNumberOfQueries().value(), cacheFactory, new DdlSqlToCommandConverter(), (Long)clusterCfg.planner().maxPlanningTime().value(), (Integer)nodeCfg.planner().threadCount().value(), metricManager, schemaManager);
    }

    public PrepareServiceImpl(String nodeName, int cacheSize, CacheFactory cacheFactory, DdlSqlToCommandConverter ddlConverter, long plannerTimeout, int plannerThreadCount, MetricManager metricManager, SqlSchemaManager schemaManager) {
        this.nodeName = nodeName;
        this.ddlConverter = ddlConverter;
        this.plannerTimeout = plannerTimeout;
        this.metricManager = metricManager;
        this.plannerThreadCount = plannerThreadCount;
        this.schemaManager = schemaManager;
        this.sqlPlanCacheMetricSource = new SqlPlanCacheMetricSource();
        this.cache = cacheFactory.create(cacheSize, this.sqlPlanCacheMetricSource);
    }

    @Override
    public void start() {
        this.planningPool = new ThreadPoolExecutor(this.plannerThreadCount, this.plannerThreadCount, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create((String)this.nodeName, (String)"sql-planning-pool", (IgniteLogger)LOG, (ThreadOperation[])ThreadOperation.NOTHING_ALLOWED));
        this.planningPool.allowCoreThreadTimeOut(true);
        this.metricManager.registerSource((MetricSource)this.sqlPlanCacheMetricSource);
        this.metricManager.enable((MetricSource)this.sqlPlanCacheMetricSource);
        IgnitePlanner.warmup();
    }

    @Override
    public void stop() throws Exception {
        this.planningPool.shutdownNow();
        this.metricManager.unregisterSource((MetricSource)this.sqlPlanCacheMetricSource);
    }

    @Override
    public CompletableFuture<QueryPlan> prepareAsync(ParsedResult parsedResult, SqlOperationContext operationContext) {
        String schemaName = operationContext.defaultSchemaName();
        assert (schemaName != null);
        SchemaPlus schema = this.schemaManager.schema(operationContext.operationTime().longValue()).getSubSchema(schemaName);
        if (schema == null) {
            return CompletableFuture.failedFuture((Throwable)new SchemaNotFoundException(schemaName));
        }
        QueryCancel cancelHandler = operationContext.cancel();
        assert (cancelHandler != null);
        boolean explicitTx = operationContext.txContext() != null && operationContext.txContext().explicitTx() != null;
        PlanningContext planningContext = PlanningContext.builder().frameworkConfig(Frameworks.newConfigBuilder((FrameworkConfig)Commons.FRAMEWORK_CONFIG).defaultSchema(schema).build()).query(parsedResult.originalQuery()).plannerTimeout(this.plannerTimeout).parameters(Commons.arrayToMap(operationContext.parameters())).explicitTx(explicitTx).build();
        CompletableFuture<QueryPlan> result = this.prepareAsync0(parsedResult, planningContext);
        return result.exceptionally(ex -> {
            Throwable th = ExceptionUtils.unwrapCause((Throwable)ex);
            throw new CompletionException(SqlExceptionMapperUtil.mapToPublicSqlException(th));
        });
    }

    private CompletableFuture<QueryPlan> prepareAsync0(ParsedResult parsedResult, PlanningContext planningContext) {
        switch (parsedResult.queryType()) {
            case QUERY: {
                return this.prepareQuery(parsedResult, planningContext);
            }
            case DDL: {
                return this.prepareDdl(parsedResult, planningContext);
            }
            case KILL: {
                return this.prepareKill(parsedResult);
            }
            case DML: {
                return this.prepareDml(parsedResult, planningContext);
            }
            case EXPLAIN: {
                return this.prepareExplain(parsedResult, planningContext);
            }
        }
        throw new AssertionError((Object)("Unexpected queryType=" + String.valueOf((Object)parsedResult.queryType())));
    }

    private CompletableFuture<QueryPlan> prepareDdl(ParsedResult parsedResult, PlanningContext ctx) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof SqlDdl) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return CompletableFuture.completedFuture(new DdlPlan(this.nextPlanId(), this.ddlConverter.convert((SqlDdl)sqlNode, ctx)));
    }

    private CompletableFuture<QueryPlan> prepareKill(ParsedResult parsedResult) {
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (sqlNode instanceof IgniteSqlKill) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return CompletableFuture.completedFuture(new KillPlan(this.nextPlanId(), KillCommand.fromSqlCall((IgniteSqlKill)sqlNode)));
    }

    private CompletableFuture<QueryPlan> prepareExplain(ParsedResult parsedResult, PlanningContext ctx) {
        CompletableFuture<QueryPlan> result;
        SqlNode parsedTree = parsedResult.parsedTree();
        assert (PrepareServiceImpl.single(parsedTree));
        assert (parsedTree instanceof SqlExplain) : parsedTree.getClass().getCanonicalName();
        SqlNode explicandum = ((SqlExplain)parsedTree).getExplicandum();
        SqlQueryType queryType = Commons.getQueryType(explicandum);
        if (queryType != SqlQueryType.QUERY && queryType != SqlQueryType.DML) {
            return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.STMT_PARSE_ERR, "Failed to parse query: Incorrect syntax near the keyword " + String.valueOf((Object)queryType)));
        }
        ParsedResultImpl newParsedResult = new ParsedResultImpl(queryType, parsedResult.originalQuery(), explicandum.toString(), parsedResult.dynamicParamsCount(), explicandum);
        switch (queryType) {
            case QUERY: {
                result = this.prepareQuery(newParsedResult, ctx);
                break;
            }
            case DML: {
                result = this.prepareDml(newParsedResult, ctx);
                break;
            }
            default: {
                throw new AssertionError((Object)"should not get here");
            }
        }
        return result.thenApply(plan -> {
            assert (plan instanceof ExplainablePlan) : plan == null ? "<null>" : plan.getClass().getCanonicalName();
            return new ExplainPlan(this.nextPlanId(), (ExplainablePlan)plan);
        });
    }

    private static boolean single(SqlNode sqlNode) {
        return !(sqlNode instanceof SqlNodeList);
    }

    private CompletableFuture<QueryPlan> prepareQuery(ParsedResult parsedResult, PlanningContext ctx) {
        CompletableFuture<QueryPlan> f = this.getPlanIfParameterHaveValues(parsedResult, ctx);
        if (f != null) {
            return f.thenApply(plan -> {
                boolean fastQueryOptEnabled = Commons.fastQueryOptimizationEnabled();
                if (!(plan instanceof MultiStepPlan) || !fastQueryOptEnabled) {
                    return plan;
                }
                MultiStepPlan regularPlan = (MultiStepPlan)plan;
                QueryPlan fastPlan = regularPlan.fastPlan();
                if (fastPlan != null && !ctx.explicitTx()) {
                    return fastPlan;
                }
                return regularPlan;
            });
        }
        CompletableFuture<ValidStatement> validFut = CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode sqlNode = parsedResult.parsedTree();
            assert (PrepareServiceImpl.single(sqlNode));
            ValidationResult validated = planner.validateAndGetTypeMetadata(sqlNode);
            RelDataType parameterRowType = planner.getParameterRowType();
            ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(parameterRowType);
            return new ValidStatement<ValidationResult>(parsedResult, validated, parameterMetadata);
        }, this.planningPool);
        return validFut.thenCompose(stmt -> {
            QueryPlan fastPlan;
            if (!ctx.explicitTx() && (fastPlan = this.tryOptimizeFast((ValidStatement<ValidationResult>)stmt, ctx)) != null) {
                return CompletableFuture.completedFuture(fastPlan);
            }
            CacheKey key = PrepareServiceImpl.createCacheKeyFromParameterMetadata(stmt.parsedResult, ctx, stmt.parameterMetadata);
            CompletableFuture planFut = this.cache.get(key, k -> CompletableFuture.supplyAsync(() -> {
                IgnitePlanner planner = ctx.planner();
                ValidationResult validated = (ValidationResult)stmt.value;
                ParameterMetadata parameterMetadata = stmt.parameterMetadata;
                SqlNode validatedNode = validated.sqlNode();
                IgniteRel optimizedRel = this.doOptimize(ctx, validatedNode, planner, () -> this.cache.invalidate(key));
                QueryPlan fastPlan = this.tryOptimizeFast((ValidStatement<ValidationResult>)stmt, ctx);
                ResultSetMetadata resultSetMetadata = PrepareServiceImpl.resultSetMetadata(validated.dataType(), validated.origins(), validated.aliases());
                int catalogVersion = ctx.catalogVersion();
                if (optimizedRel instanceof IgniteKeyValueGet) {
                    return new KeyValueGetPlan(this.nextPlanId(), catalogVersion, (IgniteKeyValueGet)optimizedRel, resultSetMetadata, parameterMetadata);
                }
                MultiStepPlan plan = new MultiStepPlan(this.nextPlanId(), SqlQueryType.QUERY, optimizedRel, resultSetMetadata, parameterMetadata, catalogVersion, fastPlan);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Plan prepared: \n{}\n\n{}", new Object[]{parsedResult.originalQuery(), plan.explain()});
                }
                return plan;
            }, this.planningPool));
            return planFut;
        });
    }

    private PlanId nextPlanId() {
        return new PlanId(this.prepareServiceId, this.planIdGen.getAndIncrement());
    }

    private static boolean simpleInsert(SqlNode node) {
        if (!(node instanceof SqlInsert)) {
            return false;
        }
        SqlInsert insert = (SqlInsert)node;
        SqlNode sourceNode = insert.getSource();
        if (!(sourceNode instanceof SqlBasicCall) || insert.isUpsert() || sourceNode.getKind() != SqlKind.VALUES) {
            return false;
        }
        for (SqlNode op : ((SqlBasicCall)sourceNode).getOperandList()) {
            if (!(op instanceof SqlBasicCall)) {
                return false;
            }
            SqlBasicCall opCall = (SqlBasicCall)op;
            for (SqlNode op0 : opCall.getOperandList()) {
                if (op0.getKind() == SqlKind.LITERAL) continue;
                return false;
            }
        }
        return true;
    }

    CompletableFuture<QueryPlan> prepareDmlOpt(SqlNode sqlNode, PlanningContext ctx, String originalQuery) {
        assert (PrepareServiceImpl.single(sqlNode));
        IgnitePlanner planner = ctx.planner();
        SqlNode validatedNode = planner.validate(sqlNode);
        IgniteRel optimizedRel = this.doOptimize(ctx, validatedNode, planner, null);
        RelDataType parameterRowType = planner.getParameterRowType();
        ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(parameterRowType);
        ExplainablePlan plan = optimizedRel instanceof IgniteKeyValueModify ? new KeyValueModifyPlan(this.nextPlanId(), ctx.catalogVersion(), (IgniteKeyValueModify)optimizedRel, DML_METADATA, parameterMetadata) : new MultiStepPlan(this.nextPlanId(), SqlQueryType.DML, optimizedRel, DML_METADATA, parameterMetadata, ctx.catalogVersion(), null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plan prepared: \n{}\n\n{}", new Object[]{originalQuery, plan.explain()});
        }
        return CompletableFuture.completedFuture(plan);
    }

    private CompletableFuture<QueryPlan> prepareDml(ParsedResult parsedResult, PlanningContext ctx) {
        CompletableFuture<QueryPlan> f = this.getPlanIfParameterHaveValues(parsedResult, ctx);
        if (f != null) {
            return f;
        }
        SqlNode sqlNode = parsedResult.parsedTree();
        assert (PrepareServiceImpl.single(sqlNode));
        boolean dmlSimplePlan = PrepareServiceImpl.simpleInsert(sqlNode);
        if (dmlSimplePlan) {
            return this.prepareDmlOpt(sqlNode, ctx, parsedResult.originalQuery());
        }
        CompletableFuture<ValidStatement> validFut = CompletableFuture.supplyAsync(() -> {
            IgnitePlanner planner = ctx.planner();
            SqlNode validatedNode = planner.validate(sqlNode);
            RelDataType parameterRowType = planner.getParameterRowType();
            ParameterMetadata parameterMetadata = PrepareServiceImpl.createParameterMetadata(parameterRowType);
            return new ValidStatement<SqlNode>(parsedResult, validatedNode, parameterMetadata);
        }, this.planningPool);
        return validFut.thenCompose(stmt -> {
            CacheKey key = PrepareServiceImpl.createCacheKeyFromParameterMetadata(stmt.parsedResult, ctx, stmt.parameterMetadata);
            CompletableFuture planFut = this.cache.get(key, k -> CompletableFuture.supplyAsync(() -> {
                IgnitePlanner planner = ctx.planner();
                SqlNode validatedNode = (SqlNode)stmt.value;
                ParameterMetadata parameterMetadata = stmt.parameterMetadata;
                IgniteRel optimizedRel = this.doOptimize(ctx, validatedNode, planner, () -> this.cache.invalidate(key));
                int catalogVersion = ctx.catalogVersion();
                ExplainablePlan plan = optimizedRel instanceof IgniteKeyValueModify ? new KeyValueModifyPlan(this.nextPlanId(), catalogVersion, (IgniteKeyValueModify)optimizedRel, DML_METADATA, parameterMetadata) : new MultiStepPlan(this.nextPlanId(), SqlQueryType.DML, optimizedRel, DML_METADATA, parameterMetadata, catalogVersion, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Plan prepared: \n{}\n\n{}", new Object[]{parsedResult.originalQuery(), plan.explain()});
                }
                return plan;
            }, this.planningPool));
            return planFut;
        });
    }

    @Nullable
    private QueryPlan tryOptimizeFast(ValidStatement<ValidationResult> stmt, PlanningContext planningContext) {
        if (!Commons.fastQueryOptimizationEnabled()) {
            return null;
        }
        Pair<IgniteRel, List<String>> relAndAliases = PlannerHelper.tryOptimizeSelectCount(planningContext.planner(), ((ValidationResult)stmt.value).sqlNode());
        if (relAndAliases == null) {
            return null;
        }
        IgniteRel fastOptRel = (IgniteRel)relAndAliases.left;
        List aliases = (List)relAndAliases.right;
        assert (fastOptRel != null);
        assert (aliases != null);
        RelDataType rowType = fastOptRel.getRowType();
        ResultSetMetadata resultSetMetadata = PrepareServiceImpl.resultSetMetadata(rowType, null, aliases);
        if (!(fastOptRel instanceof IgniteSelectCount)) {
            throw new IllegalStateException("Unexpected optimized node: " + String.valueOf(fastOptRel));
        }
        SelectCountPlan plan = new SelectCountPlan(this.nextPlanId(), planningContext.catalogVersion(), (IgniteSelectCount)fastOptRel, resultSetMetadata, stmt.parameterMetadata);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Plan prepared: \n{}\n\n{}", new Object[]{stmt.parsedResult.originalQuery(), fastOptRel.explain()});
        }
        return plan;
    }

    @Nullable
    private CompletableFuture<QueryPlan> getPlanIfParameterHaveValues(ParsedResult parsedResult, PlanningContext ctx) {
        CompletableFuture<QueryPlan> f;
        CacheKey cacheKey = PrepareServiceImpl.tryCreateCacheKeyFromParameterValues(parsedResult, ctx);
        if (cacheKey != null && (f = this.cache.get(cacheKey)) != null) {
            return f;
        }
        return null;
    }

    @Nullable
    private static CacheKey tryCreateCacheKeyFromParameterValues(ParsedResult parsedResult, PlanningContext ctx) {
        ColumnType[] paramTypes;
        Int2ObjectMap<Object> parameters = ctx.parameters();
        int maxParamNum = 0;
        for (Integer key : parameters.keySet()) {
            maxParamNum = Math.max(maxParamNum, key);
        }
        for (int i = 0; i < maxParamNum; ++i) {
            if (parameters.containsKey(i)) continue;
            return null;
        }
        boolean distributed = TraitUtils.distributionPresent((ImmutableList<RelTraitDef>)ctx.config().getTraitDefs());
        int catalogVersion = ctx.catalogVersion();
        if (parameters.isEmpty()) {
            paramTypes = new ColumnType[]{};
        } else {
            ColumnType[] result = new ColumnType[parameters.size()];
            for (Map.Entry entry : parameters.entrySet()) {
                Object value = entry.getValue();
                ColumnType columnType = value != null ? NativeTypeSpec.fromObject(value).asColumnType() : ColumnType.NULL;
                result[((Integer)entry.getKey()).intValue()] = columnType;
            }
            paramTypes = result;
        }
        return new CacheKey(catalogVersion, ctx.schemaName(), parsedResult.normalizedQuery(), distributed, paramTypes);
    }

    private static CacheKey createCacheKeyFromParameterMetadata(ParsedResult parsedResult, PlanningContext ctx, ParameterMetadata parameterMetadata) {
        ColumnType[] paramTypes;
        boolean distributed = TraitUtils.distributionPresent((ImmutableList<RelTraitDef>)ctx.config().getTraitDefs());
        int catalogVersion = ctx.catalogVersion();
        List<ParameterType> parameterTypes = parameterMetadata.parameterTypes();
        if (parameterTypes.isEmpty()) {
            paramTypes = CacheKey.EMPTY_CLASS_ARRAY;
        } else {
            ColumnType[] result = new ColumnType[parameterTypes.size()];
            for (int i = 0; i < parameterTypes.size(); ++i) {
                result[i] = parameterTypes.get(i).columnType();
            }
            paramTypes = result;
        }
        return new CacheKey(catalogVersion, ctx.schemaName(), parsedResult.normalizedQuery(), distributed, paramTypes);
    }

    private static ResultSetMetadata resultSetMetadata(RelDataType rowType, @Nullable List<List<String>> origins, List<String> aliases) {
        return new LazyResultSetMetadata(() -> {
            ArrayList<ColumnMetadataImpl> fieldsMeta = new ArrayList<ColumnMetadataImpl>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                RelDataTypeField fld = (RelDataTypeField)rowType.getFieldList().get(i);
                String alias = aliases.size() > i ? (String)aliases.get(i) : null;
                ColumnMetadataImpl fldMeta = new ColumnMetadataImpl(alias != null ? alias : fld.getName(), TypeUtils.columnType(fld.getType()), fld.getType().getPrecision(), fld.getType().getScale(), fld.getType().isNullable(), origins == null ? null : ColumnMetadataImpl.originFromList((List)((List)origins.get(i))));
                fieldsMeta.add(fldMeta);
            }
            return new ResultSetMetadataImpl(fieldsMeta);
        });
    }

    private IgniteRel doOptimize(PlanningContext ctx, SqlNode validatedNode, IgnitePlanner planner, @Nullable Runnable onTimeoutAction) {
        IgniteRel igniteRel;
        try {
            igniteRel = PlannerHelper.optimize(validatedNode, planner);
        }
        catch (Exception e) {
            if (ctx.timeouted()) {
                if (onTimeoutAction != null) {
                    onTimeoutAction.run();
                }
                throw new SqlException(ErrorGroups.Sql.EXECUTION_CANCELLED_ERR, "Planning of a query aborted due to planner timeout threshold is reached");
            }
            throw new CompletionException(e);
        }
        return Cloner.clone(igniteRel, Commons.emptyCluster());
    }

    private static ParameterMetadata createParameterMetadata(RelDataType parameterRowType) {
        if (parameterRowType.getFieldCount() == 0) {
            return EMPTY_PARAMETER_METADATA;
        }
        ArrayList<ParameterType> parameterTypes = new ArrayList<ParameterType>(parameterRowType.getFieldCount());
        for (int i = 0; i < parameterRowType.getFieldCount(); ++i) {
            RelDataTypeField field = (RelDataTypeField)parameterRowType.getFieldList().get(i);
            ParameterType parameterType = ParameterType.fromRelDataType(field.getType());
            parameterTypes.add(parameterType);
        }
        return new ParameterMetadata(parameterTypes);
    }

    private static class ParsedResultImpl
    implements ParsedResult {
        private final SqlQueryType queryType;
        private final String originalQuery;
        private final String normalizedQuery;
        private final int dynamicParamCount;
        private final SqlNode parsedTree;

        private ParsedResultImpl(SqlQueryType queryType, String originalQuery, String normalizedQuery, int dynamicParamCount, SqlNode parsedTree) {
            this.queryType = queryType;
            this.originalQuery = originalQuery;
            this.normalizedQuery = normalizedQuery;
            this.dynamicParamCount = dynamicParamCount;
            this.parsedTree = parsedTree;
        }

        @Override
        public SqlQueryType queryType() {
            return this.queryType;
        }

        @Override
        public String originalQuery() {
            return this.originalQuery;
        }

        @Override
        public String normalizedQuery() {
            return this.normalizedQuery;
        }

        @Override
        public int dynamicParamsCount() {
            return this.dynamicParamCount;
        }

        @Override
        public SqlNode parsedTree() {
            return this.parsedTree;
        }
    }

    private static class ValidStatement<T> {
        final ParsedResult parsedResult;
        final T value;
        final ParameterMetadata parameterMetadata;

        private ValidStatement(ParsedResult parsedResult, T value, ParameterMetadata parameterMetadata) {
            this.parsedResult = parsedResult;
            this.value = value;
            this.parameterMetadata = parameterMetadata;
        }
    }
}

