/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionSnapshotWriter;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.startup.StartupPartitionSnapshotReader;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.option.SnapshotCopierOptions;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotWriter;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final PartitionSnapshotStorage snapshotStorage;

    public PartitionSnapshotStorageFactory(PartitionSnapshotStorage snapshotStorage) {
        this.snapshotStorage = snapshotStorage;
    }

    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        return new PartitionSnapshotStorageAdapter(this.snapshotStorage, uri);
    }

    private static class PartitionSnapshotStorageAdapter
    implements SnapshotStorage {
        private final PartitionSnapshotStorage snapshotStorage;
        private final AtomicBoolean startupSnapshotOpened = new AtomicBoolean();
        private final String snapshotUri;

        PartitionSnapshotStorageAdapter(PartitionSnapshotStorage snapshotStorage, String snapshotUri) {
            this.snapshotStorage = snapshotStorage;
            this.snapshotUri = snapshotUri;
        }

        public boolean init(Void opts) {
            return true;
        }

        public void shutdown() {
        }

        @Nullable
        public SnapshotReader open() {
            if (this.startupSnapshotOpened.compareAndSet(false, true)) {
                RaftOutter.SnapshotMeta startupSnapshotMeta = this.snapshotStorage.readStartupSnapshotMeta();
                if (startupSnapshotMeta == null) {
                    return null;
                }
                return new StartupPartitionSnapshotReader(startupSnapshotMeta, this.snapshotUri);
            }
            return this.snapshotStorage.startOutgoingSnapshot();
        }

        public SnapshotCopier startToCopyFrom(String uri, SnapshotCopierOptions opts) {
            return this.snapshotStorage.startIncomingSnapshot(uri);
        }

        public SnapshotWriter create() {
            return new PartitionSnapshotWriter(this.snapshotUri);
        }

        public void setSnapshotThrottle(SnapshotThrottle snapshotThrottle) {
        }

        public SnapshotReader copyFrom(String uri, SnapshotCopierOptions opts) {
            throw new UnsupportedOperationException("Synchronous snapshot copy is not supported.");
        }

        public boolean setFilterBeforeCopyRemote() {
            return false;
        }
    }
}

