/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.running;

import org.apache.ignite.internal.util.typedef.F;

public class QueryHistoryKey {
    private final String qry;
    private final String schema;
    private final boolean loc;
    private final int hash;

    public QueryHistoryKey(String qry, String schema, boolean loc) {
        assert (qry != null);
        assert (schema != null);
        this.qry = qry;
        this.schema = schema;
        this.loc = loc;
        this.hash = 31 * (31 * qry.hashCode() + schema.hashCode()) + (loc ? 1 : 0);
    }

    public String query() {
        return this.qry;
    }

    public String schema() {
        return this.schema;
    }

    public boolean local() {
        return this.loc;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryHistoryKey key = (QueryHistoryKey)o;
        return F.eq(this.qry, key.qry) && F.eq(this.schema, key.schema) && F.eq(this.loc, key.loc);
    }
}

