/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.util.Arrays;

public class CiphertextFooters {
    private int authLength_ = -1;
    private byte[] mAuth_ = null;
    private boolean isComplete_ = false;

    public CiphertextFooters() {
    }

    public CiphertextFooters(byte[] mAuth) {
        int length = Utils.assertNonNull(mAuth, "mAuth").length;
        if (length < 0 || length > 65535) {
            throw new IllegalArgumentException("Invalid length for mAuth: " + length);
        }
        this.authLength_ = length;
        this.mAuth_ = (byte[])mAuth.clone();
        this.isComplete_ = true;
    }

    public int deserialize(byte[] b, int off) throws ParseException {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.authLength_ < 0) {
                parsedBytes += this.parseLength(b, off + parsedBytes);
            }
            if (this.mAuth_ == null) {
                parsedBytes += this.parseMauth(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public int getAuthLength() {
        return this.authLength_;
    }

    public byte[] getMAuth() {
        return this.mAuth_ != null ? (byte[])this.mAuth_.clone() : null;
    }

    public boolean isComplete() {
        return this.isComplete_;
    }

    /*
     * Exception decompiling
     */
    public byte[] toByteArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int parseLength(byte[] b, int off) throws ParseException {
        this.authLength_ = PrimitivesParser.parseUnsignedShort(b, off);
        return 2;
    }

    private int parseMauth(byte[] b, int off) throws ParseException {
        int len = b.length - off;
        if (len >= this.authLength_) {
            this.mAuth_ = Arrays.copyOfRange(b, off, off + this.authLength_);
            return this.authLength_;
        }
        throw new ParseException("Not enough bytes to parse mAuth,  needed at least " + this.authLength_ + " bytes, but only had " + len + " bytes");
    }
}

