/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentClassLoader;
import org.apache.ignite.internal.managers.deployment.GridDeploymentRequest;
import org.apache.ignite.internal.managers.deployment.GridDeploymentResponse;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.GridByteArrayList;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteNotPeerDeployable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;

@GridToStringExclude
class GridDeploymentCommunication {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private final GridMessageListener peerLsnr;
    private final ThreadLocal<Collection<UUID>> activeReqNodeIds = new ThreadLocal();
    private final GridBusyLock busyLock = new GridBusyLock();
    private final Marshaller marsh;

    GridDeploymentCommunication(GridKernalContext ctx, IgniteLogger log) {
        assert (log != null);
        this.ctx = ctx;
        this.log = log.getLogger(this.getClass());
        this.peerLsnr = new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                GridDeploymentCommunication.this.processDeploymentRequest(nodeId, msg);
            }
        };
        this.marsh = ctx.config().getMarshaller();
    }

    void start() {
        this.ctx.io().addMessageListener(GridTopic.TOPIC_CLASSLOAD, this.peerLsnr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started deployment communication.");
        }
    }

    void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping deployment communication.");
        }
        this.busyLock.block();
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_CLASSLOAD, this.peerLsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeploymentRequest(UUID nodeId, Object msg) {
        block13: {
            assert (nodeId != null);
            assert (msg != null);
            if (!this.busyLock.enterBusy()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Ignoring deployment request since grid is stopping [nodeId=" + nodeId + ", msg=" + msg + ']');
                }
                return;
            }
            try {
                GridDeploymentRequest req = (GridDeploymentRequest)msg;
                if (req.isUndeploy()) {
                    this.processUndeployRequest(nodeId, req);
                    break block13;
                }
                assert (this.activeReqNodeIds.get() == null);
                Collection<UUID> nodeIds = req.nodeIds();
                nodeIds = nodeIds == null ? new HashSet<UUID>() : new HashSet<UUID>(nodeIds);
                boolean b = nodeIds.add(nodeId);
                assert (b);
                this.activeReqNodeIds.set(nodeIds);
                try {
                    this.processResourceRequest(nodeId, req);
                }
                finally {
                    this.activeReqNodeIds.set(null);
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
    }

    private void processUndeployRequest(UUID nodeId, GridDeploymentRequest req) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received undeploy request [nodeId=" + nodeId + ", req=" + req + ']');
        }
        this.ctx.deploy().undeployTask(nodeId, req.resourceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResourceRequest(UUID nodeId, GridDeploymentRequest req) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received peer class/resource loading request [node=" + nodeId + ", req=" + req + ']');
        }
        if (req.responseTopic() == null) {
            try {
                req.responseTopic(U.unmarshal(this.marsh, req.responseTopicBytes(), U.resolveClassLoader(this.ctx.config())));
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to process deployment request (will ignore): " + req, e);
                return;
            }
        }
        GridDeploymentResponse res = new GridDeploymentResponse();
        GridDeployment dep = this.ctx.deploy().getDeployment(req.classLoaderId());
        if (dep != null) {
            InputStream in;
            ClassLoader ldr = dep.classLoader();
            if (!(ldr instanceof GridDeploymentClassLoader)) {
                String clsName = req.resourceName().replace('/', '.');
                try {
                    Class<?> cls;
                    if (clsName.endsWith(CLASS_FILE_EXTENSION)) {
                        clsName = clsName.substring(0, clsName.length() - CLASS_FILE_EXTENSION.length());
                    }
                    if (U.getAnnotation(cls = Class.forName(clsName, true, ldr), IgniteNotPeerDeployable.class) != null) {
                        String errMsg = "Attempt to peer deploy class that has @GridNotPeerDeployable annotation: " + clsName;
                        U.error(this.log, errMsg);
                        res.errorMessage(errMsg);
                        res.success(false);
                        this.sendResponse(nodeId, req.responseTopic(), res);
                        return;
                    }
                }
                catch (ClassNotFoundException | LinkageError e) {
                    U.warn(this.log, "Failed to resolve class: " + clsName, e);
                }
            }
            if ((in = ldr.getResourceAsStream(req.resourceName())) == null) {
                String errMsg = "Requested resource not found (ignoring locally): " + req.resourceName();
                if (this.log.isDebugEnabled()) {
                    this.log.debug(errMsg);
                }
                res.success(false);
                res.errorMessage(errMsg);
            } else {
                try {
                    GridByteArrayList bytes = new GridByteArrayList(1024);
                    bytes.readAll(in);
                    res.success(true);
                    res.byteSource(bytes);
                }
                catch (IOException e) {
                    String errMsg = "Failed to read resource due to IO failure: " + req.resourceName();
                    U.error(this.log, errMsg, e);
                    res.errorMessage(errMsg);
                    res.success(false);
                }
                finally {
                    U.close(in, this.log);
                }
            }
        } else {
            String errMsg = "Failed to find local deployment for peer request: " + req;
            U.warn(this.log, errMsg);
            res.success(false);
            res.errorMessage(errMsg);
        }
        this.sendResponse(nodeId, req.responseTopic(), res);
    }

    private void sendResponse(UUID nodeId, Object topic, Message res) {
        block10: {
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node != null) {
                try {
                    this.ctx.io().sendToCustomTopic(node, topic, res, (byte)1);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Sent peer class loading response [node=" + node.id() + ", res=" + res + ']');
                    }
                    break block10;
                }
                catch (ClusterTopologyCheckedException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send peer class loading response to node (node does not exist): " + nodeId);
                    }
                    break block10;
                }
                catch (IgniteCheckedException e) {
                    if (this.ctx.discovery().pingNodeNoError(nodeId)) {
                        U.error(this.log, "Failed to send peer class loading response to node: " + nodeId, e);
                    } else if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send peer class loading response to node (node does not exist): " + nodeId);
                    }
                    break block10;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send peer class loading response to node (node does not exist): " + nodeId);
            }
        }
    }

    void sendUndeployRequest(String rsrcName, Collection<ClusterNode> rmtNodes) throws IgniteCheckedException {
        assert (!rmtNodes.contains(this.ctx.discovery().localNode()));
        GridDeploymentRequest req = new GridDeploymentRequest(null, null, rsrcName, true);
        if (!rmtNodes.isEmpty()) {
            this.ctx.io().sendToGridTopic(rmtNodes, GridTopic.TOPIC_CLASSLOAD, (Message)req, (byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDeploymentResponse sendResourceRequest(final String rsrcName, IgniteUuid clsLdrId, final ClusterNode dstNode, long threshold) throws IgniteCheckedException, TimeoutException {
        Object object;
        assert (rsrcName != null);
        assert (dstNode != null);
        assert (clsLdrId != null);
        Collection<UUID> nodeIds = this.activeReqNodeIds.get();
        if (nodeIds != null && nodeIds.contains(dstNode.id())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node attempts to load resource from one of the requesters [rsrcName=" + rsrcName + ", dstNodeId=" + dstNode.id() + ", requesters=" + nodeIds + ']');
            }
            GridDeploymentResponse fake = new GridDeploymentResponse();
            fake.success(false);
            fake.errorMessage("Node attempts to load resource from one of the requesters [rsrcName=" + rsrcName + ", dstNodeId=" + dstNode.id() + ", requesters=" + nodeIds + ']');
            return fake;
        }
        Object resTopic = GridTopic.TOPIC_CLASSLOAD.topic(IgniteUuid.fromUuid(this.ctx.localNodeId()));
        GridDeploymentRequest req = new GridDeploymentRequest(resTopic, clsLdrId, rsrcName, false);
        req.nodeIds(nodeIds);
        final Object qryMux = new Object();
        final GridTuple res = new GridTuple();
        GridLocalEventListener discoLsnr = new GridLocalEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                assert (evt instanceof DiscoveryEvent);
                assert (evt.type() == 11 || evt.type() == 12);
                DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
                UUID nodeId = discoEvt.eventNode().id();
                if (!nodeId.equals(dstNode.id())) {
                    return;
                }
                GridDeploymentResponse fake = new GridDeploymentResponse();
                String errMsg = "Originating node left grid (resource will not be peer loaded) [nodeId=" + dstNode.id() + ", rsrc=" + rsrcName + ']';
                U.warn(GridDeploymentCommunication.this.log, errMsg);
                fake.success(false);
                fake.errorMessage(errMsg);
                Object object = qryMux;
                synchronized (object) {
                    res.set(fake);
                    qryMux.notifyAll();
                }
            }
        };
        GridMessageListener resLsnr = new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                assert (nodeId != null);
                assert (msg != null);
                Object object = qryMux;
                synchronized (object) {
                    if (!(msg instanceof GridDeploymentResponse)) {
                        U.error(GridDeploymentCommunication.this.log, "Received unknown peer class loading response [node=" + nodeId + ", msg=" + msg + ']');
                    } else {
                        res.set((GridDeploymentResponse)msg);
                    }
                    qryMux.notifyAll();
                }
            }
        };
        try {
            this.ctx.io().addMessageListener(resTopic, resLsnr);
            this.ctx.event().addLocalEventListener(discoLsnr, 12, 11);
            long start = U.currentTimeMillis();
            if (req.responseTopic() != null && !this.ctx.localNodeId().equals(dstNode.id())) {
                req.responseTopicBytes(U.marshal(this.marsh, req.responseTopic()));
            }
            this.ctx.io().sendToGridTopic(dstNode, GridTopic.TOPIC_CLASSLOAD, (Message)req, (byte)1);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sent peer class loading request [node=" + dstNode.id() + ", req=" + req + ']');
            }
            object = qryMux;
            synchronized (object) {
                try {
                    long timeout = threshold - start;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Waiting for peer response from node [node=" + dstNode.id() + ", timeout=" + timeout + ']');
                    }
                    while (res.get() == null && timeout > 0L) {
                        qryMux.wait(timeout);
                        timeout = threshold - U.currentTimeMillis();
                    }
                    if (timeout <= 0L) {
                        throw new TimeoutException();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    TimeoutException te = new TimeoutException("Got interrupted while waiting for response from node: " + dstNode.id());
                    te.initCause(e);
                    throw te;
                }
            }
            if (res.get() == null) {
                U.warn(this.log, "Failed to receive peer response from node within duration [node=" + dstNode.id() + ", duration=" + (U.currentTimeMillis() - start) + ']');
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Received peer loading response [node=" + dstNode.id() + ", res=" + res.get() + ']');
            }
            object = (GridDeploymentResponse)res.get();
        }
        catch (Throwable throwable) {
            this.ctx.event().removeLocalEventListener(discoLsnr, 12, 11);
            this.ctx.io().removeMessageListener(resTopic, resLsnr);
            throw throwable;
        }
        this.ctx.event().removeLocalEventListener(discoLsnr, 12, 11);
        this.ctx.io().removeMessageListener(resTopic, resLsnr);
        return object;
    }
}

