/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.U;

public interface AffinityAssignment {
    public static final int DFLT_AFFINITY_BACKUPS_THRESHOLD = 5;
    public static final int IGNITE_AFFINITY_BACKUPS_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_AFFINITY_BACKUPS_THRESHOLD", 5);
    public static final boolean IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION = IgniteSystemProperties.getBoolean("IGNITE_DISABLE_AFFINITY_MEMORY_OPTIMIZATION", false);

    public List<List<ClusterNode>> idealAssignment();

    public List<List<ClusterNode>> assignment();

    public AffinityTopologyVersion topologyVersion();

    public List<ClusterNode> get(int var1);

    public Collection<UUID> getIds(int var1);

    public Set<ClusterNode> nodes();

    public Set<ClusterNode> primaryPartitionNodes();

    public Set<Integer> primaryPartitions(UUID var1);

    public Set<Integer> backupPartitions(UUID var1);

    public Set<Integer> partitionPrimariesDifferentToIdeal();

    default public Collection<UUID> assignments2ids(List<ClusterNode> assignmentPart) {
        HashSet partIds = U.newHashSet(assignmentPart.size());
        for (ClusterNode node : assignmentPart) {
            partIds.add(node.id());
        }
        return Collections.unmodifiableCollection(partIds);
    }
}

