/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIOV2
extends PagePartitionMetaIO {
    private static final int PENDING_TREE_ROOT_OFF = 137;
    private static final int PART_META_REUSE_LIST_ROOT_OFF = 145;
    private static final int GAPS_LINK = 153;
    public static final int END_OF_PARTITION_PAGE_META_V2 = 161;

    public PagePartitionMetaIOV2(int ver) {
        super(ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setPendingTreeRoot(pageAddr, 0L);
        this.setPartitionMetaStoreReuseListRoot(pageAddr, 0L);
        this.setGapsLink(pageAddr, 0L);
    }

    @Override
    public long getPendingTreeRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 137);
    }

    @Override
    public void setPendingTreeRoot(long pageAddr, long listRoot) {
        PageUtils.putLong(pageAddr, 137, listRoot);
    }

    @Override
    public long getPartitionMetaStoreReuseListRoot(long pageAddr) {
        return PageUtils.getLong(pageAddr, 145);
    }

    @Override
    public void setPartitionMetaStoreReuseListRoot(long pageAddr, long listRoot) {
        PageUtils.putLong(pageAddr, 145, listRoot);
    }

    @Override
    public long getGapsLink(long pageAddr) {
        return PageUtils.getLong(pageAddr, 153);
    }

    @Override
    public boolean setGapsLink(long pageAddr, long link) {
        if (this.getGapsLink(pageAddr) == link) {
            return false;
        }
        PageUtils.putLong(pageAddr, 153, link);
        return true;
    }

    @Override
    protected void printFields(long pageAddr, GridStringBuilder sb) {
        super.printFields(pageAddr, sb);
        sb.a("\ttreeRoot=").a(this.getReuseListRoot(pageAddr));
        sb.a(",\n\tpendingTreeRoot=").a(this.getLastSuccessfulFullSnapshotId(pageAddr));
        sb.a(",\n\tlastSuccessfulFullSnapshotId=").a(this.getLastSuccessfulFullSnapshotId(pageAddr));
        sb.a(",\n\tlastSuccessfulSnapshotId=").a(this.getLastSuccessfulSnapshotId(pageAddr));
        sb.a(",\n\tnextSnapshotTag=").a(this.getNextSnapshotTag(pageAddr));
        sb.a(",\n\tlastSuccessfulSnapshotTag=").a(this.getLastSuccessfulSnapshotTag(pageAddr));
        sb.a(",\n\tlastAllocatedPageCount=").a(this.getLastAllocatedPageCount(pageAddr));
        sb.a(",\n\tcandidatePageCount=").a(this.getCandidatePageCount(pageAddr));
        sb.a(",\n\tcntrUpdDataPageId=").a(this.getGapsLink(pageAddr));
    }

    public void upgradePage(long pageAddr) {
        assert (PageIO.getType(pageAddr) == this.getType());
        assert (PageIO.getVersion(pageAddr) < 2);
        PageIO.setVersion(pageAddr, this.getVersion());
        this.setPendingTreeRoot(pageAddr, 0L);
        this.setPartitionMetaStoreReuseListRoot(pageAddr, 0L);
        this.setGapsLink(pageAddr, 0L);
    }
}

