/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.verify.CacheInfo;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureValue;
import org.apache.ignite.internal.processors.datastructures.DataStructureType;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicSequenceValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.visor.verify.VisorViewCacheCmd;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class ViewCacheClosure
implements IgniteCallable<List<CacheInfo>> {
    private static final long serialVersionUID = 0L;
    private String regex;
    private VisorViewCacheCmd cmd;
    @IgniteInstanceResource
    private Ignite ignite;

    public ViewCacheClosure(String regex, VisorViewCacheCmd cmd) {
        this.regex = regex;
        this.cmd = cmd;
    }

    @Override
    public List<CacheInfo> call() throws Exception {
        Pattern compiled = Pattern.compile(this.regex);
        ArrayList<CacheInfo> cacheInfo = new ArrayList<CacheInfo>();
        IgniteKernal k = (IgniteKernal)this.ignite;
        if (this.cmd == null) {
            this.cmd = VisorViewCacheCmd.CACHES;
        }
        switch (this.cmd) {
            case SEQ: {
                this.collectSequences(k.context(), compiled, cacheInfo);
                return cacheInfo;
            }
            case GROUPS: {
                Collection<CacheGroupContext> contexts = k.context().cache().cacheGroups();
                for (CacheGroupContext context : contexts) {
                    if (!context.userCache() || !compiled.matcher(context.cacheOrGroupName()).find()) continue;
                    CacheInfo ci = new CacheInfo();
                    ci.setGrpName(context.cacheOrGroupName());
                    ci.setGrpId(context.groupId());
                    ci.setCachesCnt(context.caches().size());
                    ci.setPartitions(context.config().getAffinity().partitions());
                    ci.setBackupsCnt(context.config().getBackups());
                    ci.setAffinityClsName(context.config().getAffinity().getClass().getSimpleName());
                    ci.setMode(context.config().getCacheMode());
                    ci.setAtomicityMode(context.config().getAtomicityMode());
                    ci.setMapped(this.mapped(context.caches().iterator().next().name()));
                    cacheInfo.add(ci);
                }
                return cacheInfo;
            }
        }
        Map<String, DynamicCacheDescriptor> descMap = k.context().cache().cacheDescriptors();
        for (Map.Entry<String, DynamicCacheDescriptor> entry : descMap.entrySet()) {
            DynamicCacheDescriptor desc = entry.getValue();
            if (!desc.cacheType().userCache() || !compiled.matcher(desc.cacheName()).find()) continue;
            CacheInfo ci = new CacheInfo();
            ci.setCacheName(desc.cacheName());
            ci.setCacheId(desc.cacheId());
            ci.setGrpName(desc.groupDescriptor().groupName());
            ci.setGrpId(desc.groupDescriptor().groupId());
            ci.setPartitions(desc.cacheConfiguration().getAffinity().partitions());
            ci.setBackupsCnt(desc.cacheConfiguration().getBackups());
            ci.setAffinityClsName(desc.cacheConfiguration().getAffinity().getClass().getSimpleName());
            ci.setMode(desc.cacheConfiguration().getCacheMode());
            ci.setAtomicityMode(desc.cacheConfiguration().getAtomicityMode());
            ci.setMapped(this.mapped(desc.cacheName()));
            cacheInfo.add(ci);
        }
        return cacheInfo;
    }

    private int mapped(String cacheName) {
        int mapped = 0;
        ClusterGroup srvs = this.ignite.cluster().forServers();
        Collection<ClusterNode> nodes = srvs.forDataNodes(cacheName).nodes();
        for (ClusterNode node : nodes) {
            mapped += this.ignite.affinity(cacheName).primaryPartitions(node).length;
        }
        return mapped;
    }

    private void collectSequences(GridKernalContext ctx, Pattern compiled, List<CacheInfo> cacheInfo) throws IgniteCheckedException {
        String dsCacheName = "ignite-sys-atomic-cache@default-ds-group";
        IgniteInternalCache cache0 = ctx.cache().cache(dsCacheName);
        Iterator iter = cache0.scanIterator(false, null);
        while (iter.hasNext()) {
            String name;
            Cache.Entry entry = iter.next();
            AtomicDataStructureValue val = (AtomicDataStructureValue)entry.getValue();
            if (val.type() != DataStructureType.ATOMIC_SEQ || !compiled.matcher(name = ((GridCacheInternalKey)entry.getKey()).name()).find()) continue;
            CacheInfo ci = new CacheInfo();
            ci.setSeqName(name);
            ci.setSeqVal(((GridCacheAtomicSequenceValue)val).get());
            cacheInfo.add(ci);
        }
    }
}

