/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.tracing;

import java.util.Iterator;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;

public class TraceableIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private final Span span;

    public TraceableIterator(Iterator<T> iter) {
        this.iter = iter;
        this.span = MTC.span();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            boolean bl = this.iter.hasNext();
            return bl;
        }
        catch (Throwable th) {
            this.span.addTag("error", th::getMessage);
            throw th;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T next() {
        try (MTC.TraceSurroundings ignored = MTC.supportContinual(this.span);){
            T t = this.iter.next();
            return t;
        }
        catch (Throwable th) {
            this.span.addTag("error", th::getMessage);
            throw th;
        }
    }
}

