/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.grpc.ChannelCredentials;
import io.grpc.ChannelLogger;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.inprocess.InProcessTransports;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.netty.NettyChannelBuilder;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;

public class DelegatingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;

    public DelegatingTransportFactory(NettyChannelBuilder builder) {
        this.delegate = builder.buildTransportFactory();
    }

    public ConnectionClientTransport newClientTransport(SocketAddress address, ClientTransportFactory.ClientTransportOptions options, ChannelLogger logger) {
        if (address instanceof InProcessSocketAddress) {
            InProcessSocketAddress inProcSocketAddress = (InProcessSocketAddress)address;
            return InProcessTransports.create(inProcSocketAddress, options);
        }
        return this.delegate.newClientTransport(address, options, logger);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.delegate.getScheduledExecutorService();
    }

    public ClientTransportFactory.SwapChannelCredentialsResult swapChannelCredentials(ChannelCredentials channelCreds) {
        return this.delegate.swapChannelCredentials(channelCreds);
    }

    public void close() {
        this.delegate.close();
    }

    public Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(SocketAddress.class);
    }
}

