/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.server;

import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.inbox.IMqttBrokerClient;
import org.apache.bifromq.sessiondict.rpc.proto.ExistReply;
import org.apache.bifromq.sessiondict.rpc.proto.ExistRequest;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetInboxStateRequest;
import org.apache.bifromq.sessiondict.rpc.proto.GetReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetRequest;
import org.apache.bifromq.sessiondict.rpc.proto.KillAllReply;
import org.apache.bifromq.sessiondict.rpc.proto.KillAllRequest;
import org.apache.bifromq.sessiondict.rpc.proto.KillReply;
import org.apache.bifromq.sessiondict.rpc.proto.KillRequest;
import org.apache.bifromq.sessiondict.rpc.proto.Quit;
import org.apache.bifromq.sessiondict.rpc.proto.Session;
import org.apache.bifromq.sessiondict.rpc.proto.SessionDictServiceGrpc;
import org.apache.bifromq.sessiondict.rpc.proto.SubReply;
import org.apache.bifromq.sessiondict.rpc.proto.SubRequest;
import org.apache.bifromq.sessiondict.rpc.proto.UnsubReply;
import org.apache.bifromq.sessiondict.rpc.proto.UnsubRequest;
import org.apache.bifromq.sessiondict.server.ISessionRegistry;
import org.apache.bifromq.sessiondict.server.SessionExistPipeline;
import org.apache.bifromq.sessiondict.server.SessionRegister;
import org.apache.bifromq.sessiondict.server.SessionRegistry;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionDictService
extends SessionDictServiceGrpc.SessionDictServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionDictService.class);
    private final ISessionRegistry sessionRegistry;
    private final IMqttBrokerClient mqttBrokerClient;
    private final IInboxClient inboxClient;

    SessionDictService(IMqttBrokerClient mqttBrokerClient, IInboxClient inboxClient) {
        this.mqttBrokerClient = mqttBrokerClient;
        this.inboxClient = inboxClient;
        this.sessionRegistry = new SessionRegistry();
    }

    public StreamObserver<Session> dict(StreamObserver<Quit> responseObserver) {
        return new SessionRegister((sessionOwner, reg, register) -> {
            if (reg) {
                this.sessionRegistry.add(sessionOwner, register);
            } else {
                this.sessionRegistry.remove(sessionOwner, register);
            }
        }, responseObserver);
    }

    public void kill(KillRequest request, StreamObserver<KillReply> responseObserver) {
        UnaryResponse.response(ignore -> {
            String tenantId = request.getTenantId();
            Optional<ISessionRegistry.SessionRegistration> reg = this.sessionRegistry.findRegistration(tenantId, request.getUserId(), request.getClientId());
            reg.ifPresent(sessionRegistration -> sessionRegistration.stop(request.getKiller(), request.getServerRedirection()));
            return CompletableFuture.completedFuture(KillReply.newBuilder().setReqId(request.getReqId()).setResult(KillReply.Result.OK).build());
        }, responseObserver);
    }

    public void killAll(KillAllRequest request, StreamObserver<KillAllReply> responseObserver) {
        UnaryResponse.response(ignore -> {
            String tenantId = request.getTenantId();
            Iterable<ISessionRegistry.SessionRegistration> sessionRegistrations = request.hasUserId() ? this.sessionRegistry.findRegistrations(tenantId, request.getUserId()) : this.sessionRegistry.findRegistrations(tenantId);
            try {
                sessionRegistrations.forEach(reg -> reg.stop(request.getKiller(), request.getServerRedirection()));
                return CompletableFuture.completedFuture(KillAllReply.newBuilder().setReqId(request.getReqId()).setResult(KillAllReply.Result.OK).build());
            }
            catch (Throwable e) {
                log.debug("Failed to kick", e);
                return CompletableFuture.completedFuture(KillAllReply.newBuilder().setReqId(request.getReqId()).setResult(KillAllReply.Result.ERROR).build());
            }
        }, responseObserver);
    }

    public void get(GetRequest request, StreamObserver<GetReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            Optional<ClientInfo> sessionOwner = this.sessionRegistry.get((String)tenantId, request.getUserId(), request.getClientId());
            return sessionOwner.map(clientInfo -> CompletableFuture.completedFuture(GetReply.newBuilder().setReqId(request.getReqId()).setResult(GetReply.Result.OK).setOwner(clientInfo).build())).orElseGet(() -> CompletableFuture.completedFuture(GetReply.newBuilder().setReqId(request.getReqId()).setResult(GetReply.Result.NOT_FOUND).build()));
        }, responseObserver);
    }

    public StreamObserver<ExistRequest> exist(StreamObserver<ExistReply> responseObserver) {
        return new SessionExistPipeline(this.sessionRegistry, responseObserver);
    }

    public void inboxState(GetInboxStateRequest request, StreamObserver<GetInboxStateReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            Optional<ClientInfo> sessionOwner = this.sessionRegistry.get((String)tenantId, request.getUserId(), request.getClientId());
            if (sessionOwner.isEmpty() || sessionOwner.get().getMetadataOrDefault("sessionType", "").equals("p")) {
                return this.inboxClient.state(request.getReqId(), request.getTenantId(), request.getUserId(), request.getClientId()).thenApply(r -> {
                    switch (r.getCode()) {
                        case OK: {
                            return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.OK).setState(r.getState()).build();
                        }
                        case NO_INBOX: {
                            return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.NO_INBOX).build();
                        }
                        case TRY_LATER: {
                            return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.TRY_LATER).build();
                        }
                        case BACK_PRESSURE_REJECTED: {
                            return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.BACK_PRESSURE_REJECTED).build();
                        }
                    }
                    return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.ERROR).build();
                });
            }
            return this.mqttBrokerClient.inboxState(request.getReqId(), request.getTenantId(), sessionOwner.get().getMetadataOrDefault("channelId", ""), sessionOwner.get().getMetadataOrDefault("broker", "")).thenApply(r -> {
                switch (r.getCode()) {
                    case OK: {
                        return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.OK).setState(r.getState()).build();
                    }
                    case NO_INBOX: {
                        return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.NO_INBOX).build();
                    }
                    case TRY_LATER: {
                        return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.TRY_LATER).build();
                    }
                    case BACK_PRESSURE_REJECTED: {
                        return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.BACK_PRESSURE_REJECTED).build();
                    }
                }
                return GetInboxStateReply.newBuilder().setReqId(request.getReqId()).setCode(GetInboxStateReply.Code.ERROR).build();
            });
        }, responseObserver);
    }

    public void sub(SubRequest request, StreamObserver<SubReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            Optional<ClientInfo> sessionOwner = this.sessionRegistry.get((String)tenantId, request.getUserId(), request.getClientId());
            if (sessionOwner.isEmpty()) {
                return CompletableFuture.completedFuture(SubReply.newBuilder().setReqId(request.getReqId()).setResult(SubReply.Result.NO_SESSION).build());
            }
            return this.mqttBrokerClient.sub(request.getReqId(), request.getTenantId(), sessionOwner.get().getMetadataOrDefault("channelId", ""), request.getTopicFilter(), request.getQos(), sessionOwner.get().getMetadataOrDefault("broker", "")).thenApply(r -> SubReply.newBuilder().setReqId(request.getReqId()).setResult(SubReply.Result.forNumber((int)r.getResult().getNumber())).build());
        }, responseObserver);
    }

    public void unsub(UnsubRequest request, StreamObserver<UnsubReply> responseObserver) {
        UnaryResponse.response(tenantId -> {
            Optional<ClientInfo> sessionOwner = this.sessionRegistry.get((String)tenantId, request.getUserId(), request.getClientId());
            if (sessionOwner.isEmpty()) {
                return CompletableFuture.completedFuture(UnsubReply.newBuilder().setReqId(request.getReqId()).setResult(UnsubReply.Result.NO_SESSION).build());
            }
            return this.mqttBrokerClient.unsub(request.getReqId(), request.getTenantId(), sessionOwner.get().getMetadataOrDefault("channelId", ""), request.getTopicFilter(), sessionOwner.get().getMetadataOrDefault("broker", "")).thenApply(r -> UnsubReply.newBuilder().setReqId(request.getReqId()).setResult(UnsubReply.Result.forNumber((int)r.getResult().getNumber())).build());
        }, responseObserver);
    }

    void close() {
        this.sessionRegistry.close();
    }
}

