/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrivilege;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisAuthorizerImpl
implements PolarisAuthorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisAuthorizerImpl.class);
    private static final SetMultimap<PolarisPrivilege, PolarisPrivilege> SUPER_PRIVILEGES = HashMultimap.create();
    private final RealmConfig realmConfig;

    @Inject
    public PolarisAuthorizerImpl(RealmConfig realmConfig) {
        this.realmConfig = realmConfig;
    }

    public boolean matchesOrIsSubsumedBy(PolarisPrivilege desiredPrivilege, PolarisPrivilege grantedPrivilege) {
        if (grantedPrivilege == desiredPrivilege) {
            return true;
        }
        return SUPER_PRIVILEGES.containsKey((Object)desiredPrivilege) && SUPER_PRIVILEGES.get((Object)desiredPrivilege).contains((Object)grantedPrivilege);
    }

    @Override
    public void authorizeOrThrow(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable PolarisResolvedPathWrapper target, @Nullable PolarisResolvedPathWrapper secondary) {
        this.authorizeOrThrow(polarisPrincipal, activatedEntities, authzOp, target == null ? null : List.of(target), secondary == null ? null : List.of(secondary));
    }

    @Override
    public void authorizeOrThrow(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable List<PolarisResolvedPathWrapper> targets, @Nullable List<PolarisResolvedPathWrapper> secondaries) {
        boolean enforceCredentialRotationRequiredState = this.realmConfig.getConfig(FeatureConfiguration.ENFORCE_PRINCIPAL_CREDENTIAL_ROTATION_REQUIRED_CHECKING);
        if (enforceCredentialRotationRequiredState && polarisPrincipal.getProperties().containsKey("CREDENTIAL_ROTATION_REQUIRED") && authzOp != PolarisAuthorizableOperation.ROTATE_CREDENTIALS) {
            throw new ForbiddenException("Principal '%s' is not authorized for op %s due to PRINCIPAL_CREDENTIAL_ROTATION_REQUIRED_STATE", new Object[]{polarisPrincipal.getName(), authzOp});
        }
        if (!this.isAuthorized(polarisPrincipal, activatedEntities, authzOp, targets, secondaries)) {
            throw new ForbiddenException("Principal '%s' with activated PrincipalRoles '%s' and activated grants via '%s' is not authorized for op %s", new Object[]{polarisPrincipal.getName(), polarisPrincipal.getRoles(), activatedEntities.stream().map(PolarisEntityCore::getName).collect(Collectors.toSet()), authzOp});
        }
    }

    public boolean isAuthorized(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable PolarisResolvedPathWrapper target, @Nullable PolarisResolvedPathWrapper secondary) {
        return this.isAuthorized(polarisPrincipal, activatedEntities, authzOp, target == null ? null : List.of(target), secondary == null ? null : List.of(secondary));
    }

    public boolean isAuthorized(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable List<PolarisResolvedPathWrapper> targets, @Nullable List<PolarisResolvedPathWrapper> secondaries) {
        Set<Long> entityIdSet = activatedEntities.stream().map(PolarisEntityCore::getId).collect(Collectors.toSet());
        for (PolarisPrivilege privilegeOnTarget : authzOp.getPrivilegesOnTarget()) {
            Preconditions.checkState((targets != null ? 1 : 0) != 0, (String)"Got null target when authorizing authzOp %s for privilege %s", (Object)((Object)authzOp), (Object)((Object)privilegeOnTarget));
            for (PolarisResolvedPathWrapper target : targets) {
                if (this.hasTransitivePrivilege(polarisPrincipal, entityIdSet, privilegeOnTarget, target)) continue;
                return false;
            }
        }
        for (PolarisPrivilege privilegeOnSecondary : authzOp.getPrivilegesOnSecondary()) {
            Preconditions.checkState((secondaries != null ? 1 : 0) != 0, (String)"Got null secondary when authorizing authzOp %s for privilege %s", (Object)((Object)authzOp), (Object)((Object)privilegeOnSecondary));
            for (PolarisResolvedPathWrapper secondary : secondaries) {
                if (this.hasTransitivePrivilege(polarisPrincipal, entityIdSet, privilegeOnSecondary, secondary)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasTransitivePrivilege(@Nonnull PolarisPrincipal polarisPrincipal, Set<Long> activatedGranteeIds, PolarisPrivilege desiredPrivilege, PolarisResolvedPathWrapper resolvedPath) {
        for (ResolvedPolarisEntity resolvedSecurableEntity : resolvedPath.getResolvedFullPath()) {
            Preconditions.checkState((resolvedSecurableEntity.getGrantRecordsAsSecurable() != null ? 1 : 0) != 0, (String)"Got null grantRecordsAsSecurable for resolvedSecurableEntity %s", (Object)resolvedSecurableEntity);
            for (PolarisGrantRecord grantRecord : resolvedSecurableEntity.getGrantRecordsAsSecurable()) {
                if (!this.matchesOrIsSubsumedBy(desiredPrivilege, PolarisPrivilege.fromCode(grantRecord.getPrivilegeCode())) || !activatedGranteeIds.contains(grantRecord.getGranteeId())) continue;
                LOGGER.debug("Satisfied privilege {} with grantRecord {} from securable {} for principalName {} and activatedIds {}", new Object[]{desiredPrivilege, grantRecord, resolvedSecurableEntity, polarisPrincipal.getName(), activatedGranteeIds});
                return true;
            }
        }
        LOGGER.debug("Failed to satisfy privilege {} for principalName {} on resolvedPath {}", new Object[]{desiredPrivilege, polarisPrincipal.getName(), resolvedPath});
        return false;
    }

    static {
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.SERVICE_MANAGE_ACCESS, List.of(PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_MANAGE_ACCESS, List.of(PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_USAGE, List.of(PolarisPrivilege.CATALOG_ROLE_USAGE));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_USAGE, List.of(PolarisPrivilege.PRINCIPAL_ROLE_USAGE));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_CREATE, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_CREATE, PolarisPrivilege.NAMESPACE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_CREATE, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_CREATE, PolarisPrivilege.TABLE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_CREATE, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_CREATE, PolarisPrivilege.VIEW_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_DROP, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_DROP, PolarisPrivilege.NAMESPACE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_DROP, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_DROP, PolarisPrivilege.TABLE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_DROP, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_DROP, PolarisPrivilege.VIEW_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_LIST, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_CREATE, PolarisPrivilege.NAMESPACE_FULL_METADATA, PolarisPrivilege.NAMESPACE_LIST, PolarisPrivilege.NAMESPACE_READ_PROPERTIES, PolarisPrivilege.NAMESPACE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_LIST, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_CREATE, PolarisPrivilege.TABLE_FULL_METADATA, PolarisPrivilege.TABLE_LIST, PolarisPrivilege.TABLE_READ_DATA, PolarisPrivilege.TABLE_READ_PROPERTIES, PolarisPrivilege.TABLE_WRITE_DATA, PolarisPrivilege.TABLE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_LIST, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_CREATE, PolarisPrivilege.VIEW_FULL_METADATA, PolarisPrivilege.VIEW_LIST, PolarisPrivilege.VIEW_READ_PROPERTIES, PolarisPrivilege.VIEW_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_READ_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_FULL_METADATA, PolarisPrivilege.NAMESPACE_READ_PROPERTIES, PolarisPrivilege.NAMESPACE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_READ_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_FULL_METADATA, PolarisPrivilege.TABLE_READ_DATA, PolarisPrivilege.TABLE_READ_PROPERTIES, PolarisPrivilege.TABLE_WRITE_DATA, PolarisPrivilege.TABLE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_READ_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_FULL_METADATA, PolarisPrivilege.VIEW_READ_PROPERTIES, PolarisPrivilege.VIEW_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_WRITE_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_FULL_METADATA, PolarisPrivilege.NAMESPACE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_WRITE_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_FULL_METADATA, PolarisPrivilege.TABLE_WRITE_DATA, PolarisPrivilege.TABLE_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_WRITE_PROPERTIES, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_FULL_METADATA, PolarisPrivilege.VIEW_WRITE_PROPERTIES));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_READ_DATA, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.TABLE_READ_DATA, PolarisPrivilege.TABLE_WRITE_DATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_WRITE_DATA, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.TABLE_WRITE_DATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_FULL_METADATA, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.NAMESPACE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_FULL_METADATA, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.TABLE_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_FULL_METADATA, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.VIEW_FULL_METADATA));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_MANAGE_METADATA, List.of(PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_MANAGE_CONTENT, List.of(PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_CREATE, List.of(PolarisPrivilege.CATALOG_CREATE, PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_DROP, List.of(PolarisPrivilege.CATALOG_DROP, PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_LIST, List.of(PolarisPrivilege.CATALOG_CREATE, PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.CATALOG_LIST, PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_READ_PROPERTIES, PolarisPrivilege.CATALOG_WRITE_PROPERTIES, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_READ_PROPERTIES, List.of(PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_READ_PROPERTIES, PolarisPrivilege.CATALOG_WRITE_PROPERTIES, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_WRITE_PROPERTIES, List.of(PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_WRITE_PROPERTIES, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_FULL_METADATA, List.of(PolarisPrivilege.CATALOG_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_LIST_GRANTS, List.of(PolarisPrivilege.PRINCIPAL_LIST_GRANTS, PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_LIST_GRANTS, List.of(PolarisPrivilege.PRINCIPAL_ROLE_LIST_GRANTS, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_LIST_GRANTS, List.of(PolarisPrivilege.CATALOG_ROLE_LIST_GRANTS, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_LIST_GRANTS, List.of(PolarisPrivilege.CATALOG_LIST_GRANTS, PolarisPrivilege.CATALOG_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_LIST_GRANTS, List.of(PolarisPrivilege.NAMESPACE_LIST_GRANTS, PolarisPrivilege.NAMESPACE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_LIST_GRANTS, List.of(PolarisPrivilege.TABLE_LIST_GRANTS, PolarisPrivilege.TABLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_LIST_GRANTS, List.of(PolarisPrivilege.VIEW_LIST_GRANTS, PolarisPrivilege.VIEW_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.CATALOG_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.NAMESPACE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.TABLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.VIEW_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.VIEW_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.POLICY_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_CREATE, List.of(PolarisPrivilege.PRINCIPAL_CREATE, PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_DROP, List.of(PolarisPrivilege.PRINCIPAL_DROP, PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_LIST, List.of(PolarisPrivilege.PRINCIPAL_LIST, PolarisPrivilege.PRINCIPAL_CREATE, PolarisPrivilege.PRINCIPAL_READ_PROPERTIES, PolarisPrivilege.PRINCIPAL_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_READ_PROPERTIES, List.of(PolarisPrivilege.PRINCIPAL_READ_PROPERTIES, PolarisPrivilege.PRINCIPAL_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_WRITE_PROPERTIES, List.of(PolarisPrivilege.PRINCIPAL_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_FULL_METADATA, List.of(PolarisPrivilege.PRINCIPAL_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_FOR_GRANTEE, List.of(PolarisPrivilege.PRINCIPAL_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROTATE_CREDENTIALS, List.of(PolarisPrivilege.PRINCIPAL_ROTATE_CREDENTIALS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_RESET_CREDENTIALS, List.of(PolarisPrivilege.PRINCIPAL_RESET_CREDENTIALS, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_CREATE, List.of(PolarisPrivilege.PRINCIPAL_ROLE_CREATE, PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_DROP, List.of(PolarisPrivilege.PRINCIPAL_ROLE_DROP, PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_LIST, List.of(PolarisPrivilege.PRINCIPAL_ROLE_LIST, PolarisPrivilege.PRINCIPAL_ROLE_CREATE, PolarisPrivilege.PRINCIPAL_ROLE_READ_PROPERTIES, PolarisPrivilege.PRINCIPAL_ROLE_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_READ_PROPERTIES, List.of(PolarisPrivilege.PRINCIPAL_ROLE_READ_PROPERTIES, PolarisPrivilege.PRINCIPAL_ROLE_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_WRITE_PROPERTIES, List.of(PolarisPrivilege.PRINCIPAL_ROLE_WRITE_PROPERTIES, PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, List.of(PolarisPrivilege.PRINCIPAL_ROLE_FULL_METADATA, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE, List.of(PolarisPrivilege.PRINCIPAL_ROLE_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.SERVICE_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_CREATE, List.of(PolarisPrivilege.CATALOG_ROLE_CREATE, PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_DROP, List.of(PolarisPrivilege.CATALOG_ROLE_DROP, PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_LIST, List.of(PolarisPrivilege.CATALOG_ROLE_LIST, PolarisPrivilege.CATALOG_ROLE_CREATE, PolarisPrivilege.CATALOG_ROLE_READ_PROPERTIES, PolarisPrivilege.CATALOG_ROLE_WRITE_PROPERTIES, PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_READ_PROPERTIES, List.of(PolarisPrivilege.CATALOG_ROLE_READ_PROPERTIES, PolarisPrivilege.CATALOG_ROLE_WRITE_PROPERTIES, PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_WRITE_PROPERTIES, List.of(PolarisPrivilege.CATALOG_ROLE_WRITE_PROPERTIES, PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, List.of(PolarisPrivilege.CATALOG_ROLE_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE, List.of(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_ON_SECURABLE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE, List.of(PolarisPrivilege.CATALOG_ROLE_MANAGE_GRANTS_FOR_GRANTEE, PolarisPrivilege.CATALOG_MANAGE_ACCESS));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_CREATE, List.of(PolarisPrivilege.POLICY_CREATE, PolarisPrivilege.POLICY_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_WRITE, List.of(PolarisPrivilege.POLICY_WRITE, PolarisPrivilege.POLICY_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_DROP, List.of(PolarisPrivilege.POLICY_DROP, PolarisPrivilege.POLICY_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_READ, List.of(PolarisPrivilege.POLICY_READ, PolarisPrivilege.POLICY_WRITE, PolarisPrivilege.POLICY_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_LIST, List.of(PolarisPrivilege.POLICY_LIST, PolarisPrivilege.POLICY_CREATE, PolarisPrivilege.POLICY_READ, PolarisPrivilege.POLICY_WRITE, PolarisPrivilege.POLICY_FULL_METADATA, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_ATTACH, List.of(PolarisPrivilege.POLICY_ATTACH, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.POLICY_DETACH, List.of(PolarisPrivilege.POLICY_DETACH, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_ATTACH_POLICY, List.of(PolarisPrivilege.CATALOG_ATTACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_ATTACH_POLICY, List.of(PolarisPrivilege.NAMESPACE_ATTACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_ATTACH_POLICY, List.of(PolarisPrivilege.TABLE_ATTACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.CATALOG_DETACH_POLICY, List.of(PolarisPrivilege.CATALOG_DETACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.NAMESPACE_DETACH_POLICY, List.of(PolarisPrivilege.NAMESPACE_DETACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
        SUPER_PRIVILEGES.putAll((Object)PolarisPrivilege.TABLE_DETACH_POLICY, List.of(PolarisPrivilege.TABLE_DETACH_POLICY, PolarisPrivilege.CATALOG_MANAGE_METADATA, PolarisPrivilege.CATALOG_MANAGE_CONTENT));
    }
}

