/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class PolarisVersion {
    private static final String MF_VERSION = "Apache-Polaris-Version";
    private static final String MF_IS_RELEASE = "Apache-Polaris-Is-Release";
    private static final String MF_BUILD_GIT_HEAD = "Apache-Polaris-Build-Git-Head";
    private static final String MF_BUILD_GIT_DESCRIBE = "Apache-Polaris-Build-Git-Describe";
    private static final String MF_BUILD_TIMESTAMP = "Apache-Polaris-Build-Timestamp";
    private static final String MF_BUILD_SYSTEM = "Apache-Polaris-Build-System";
    private static final String MF_BUILD_JAVA_VERSION = "Apache-Polaris-Build-Java-Version";
    private static final List<String> MF_ALL = List.of("Apache-Polaris-Version", "Apache-Polaris-Is-Release", "Apache-Polaris-Build-Git-Head", "Apache-Polaris-Build-Git-Describe", "Apache-Polaris-Build-Timestamp", "Apache-Polaris-Build-System", "Apache-Polaris-Build-Java-Version");

    private PolarisVersion() {
    }

    public static String polarisVersionString() {
        return PolarisVersionNumber.POLARIS_VERSION;
    }

    public static boolean isReleaseBuild() {
        return "true".equals(PolarisVersionJarInfo.buildInfo(MF_IS_RELEASE).orElse("false"));
    }

    public static Optional<String> getBuildReleasedVersion() {
        return PolarisVersionJarInfo.buildInfo(MF_VERSION);
    }

    public static Optional<String> getBuildGitHead() {
        return PolarisVersionJarInfo.buildInfo(MF_BUILD_GIT_HEAD);
    }

    public static Optional<String> getBuildGitTag() {
        return PolarisVersionJarInfo.buildInfo(MF_BUILD_GIT_DESCRIBE);
    }

    public static Optional<String> getBuildJavaVersion() {
        return PolarisVersionJarInfo.buildInfo(MF_BUILD_JAVA_VERSION);
    }

    public static Optional<String> getBuildSystem() {
        return PolarisVersionJarInfo.buildInfo(MF_BUILD_SYSTEM);
    }

    public static Optional<String> getBuildTimestamp() {
        return PolarisVersionJarInfo.buildInfo(MF_BUILD_TIMESTAMP);
    }

    public static String readNoticeFile() {
        return PolarisVersion.readResource("NOTICE");
    }

    public static String readSourceLicenseFile() {
        return PolarisVersion.readResource("LICENSE");
    }

    static String readResource(String resource) {
        String string;
        block8: {
            String fullResource = String.format("/META-INF/resources/apache-polaris/%s.txt", resource);
            URL resourceUrl = Objects.requireNonNull(PolarisVersion.class.getResource(fullResource), "Resource " + fullResource + " does not exist");
            InputStream in = resourceUrl.openConnection().getInputStream();
            try {
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load resource " + fullResource, e);
                }
            }
            in.close();
        }
        return string;
    }

    static final class PolarisVersionNumber {
        static final String POLARIS_VERSION;

        PolarisVersionNumber() {
        }

        static {
            try (InputStream in = PolarisVersionResource.POLARIS_VERSION_RESOURCE.openConnection().getInputStream();){
                Properties p = new Properties();
                p.load(in);
                POLARIS_VERSION = p.getProperty("polaris.version");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load Apache Polaris version from org/apache/polaris/version/polaris-version.properties resource", e);
            }
        }
    }

    static final class PolarisVersionJarInfo {
        static final Map<String, String> BUILD_INFO = new HashMap<String, String>();

        PolarisVersionJarInfo() {
        }

        static Optional<String> buildInfo(String key) {
            return Optional.ofNullable(BUILD_INFO.get(key));
        }

        static void loadManifest(String manifestFile) {
            URL polarisVersionResource = PolarisVersionResource.POLARIS_VERSION_RESOURCE;
            if ("jar".equals(polarisVersionResource.getProtocol())) {
                String path = polarisVersionResource.toString();
                int jarSep = path.lastIndexOf(33);
                if (jarSep == -1) {
                    throw new IllegalStateException("Could not determine the jar of the Apache Polaris version artifact: " + path);
                }
                String manifestPath = path.substring(0, jarSep + 1) + "/META-INF/" + manifestFile;
                try (InputStream in = URI.create(manifestPath).toURL().openConnection().getInputStream();){
                    Manifest manifest = new Manifest(in);
                    Attributes attributes = manifest.getMainAttributes();
                    MF_ALL.stream().map(Attributes.Name::new).filter(attributes::containsKey).forEach(k -> BUILD_INFO.put(k.toString(), attributes.getValue((Attributes.Name)k)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        static {
            PolarisVersionJarInfo.loadManifest("MANIFEST.MF");
        }
    }

    static final class PolarisVersionResource {
        static final URL POLARIS_VERSION_RESOURCE = Objects.requireNonNull(PolarisVersion.class.getResource("polaris-version.properties"), "Resource org/apache/polaris/version/polaris-version.properties containing the Apache Polaris version does not exist");

        PolarisVersionResource() {
        }
    }
}

