/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.polaris.core.admin.model.ConnectionConfigInfo;
import org.apache.polaris.core.admin.model.HadoopConnectionConfigInfo;
import org.apache.polaris.core.admin.model.HiveConnectionConfigInfo;
import org.apache.polaris.core.admin.model.IcebergRestConnectionConfigInfo;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.ConnectionType;
import org.apache.polaris.core.connection.hadoop.HadoopConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.hive.HiveConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.iceberg.IcebergCatalogPropertiesProvider;
import org.apache.polaris.core.connection.iceberg.IcebergRestConnectionConfigInfoDpo;
import org.apache.polaris.core.identity.dpo.ServiceIdentityInfoDpo;
import org.apache.polaris.core.identity.provider.ServiceIdentityProvider;
import org.apache.polaris.core.secrets.SecretReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="connectionTypeCode")
@JsonSubTypes(value={@JsonSubTypes.Type(value=IcebergRestConnectionConfigInfoDpo.class, name="1"), @JsonSubTypes.Type(value=HadoopConnectionConfigInfoDpo.class, name="2"), @JsonSubTypes.Type(value=HiveConnectionConfigInfoDpo.class, name="3")})
public abstract class ConnectionConfigInfoDpo
implements IcebergCatalogPropertiesProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionConfigInfoDpo.class);
    private final int connectionTypeCode;
    private final String uri;
    private final AuthenticationParametersDpo authenticationParameters;
    private final ServiceIdentityInfoDpo serviceIdentity;
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    public ConnectionConfigInfoDpo(@JsonProperty(value="connectionTypeCode", required=true) int connectionTypeCode, @JsonProperty(value="uri", required=true) @Nonnull String uri, @JsonProperty(value="authenticationParameters", required=true) @Nullable AuthenticationParametersDpo authenticationParameters, @JsonProperty(value="serviceIdentity", required=false) @Nullable ServiceIdentityInfoDpo serviceIdentity) {
        this(connectionTypeCode, uri, authenticationParameters, serviceIdentity, true);
    }

    protected ConnectionConfigInfoDpo(int connectionTypeCode, @Nonnull String uri, @Nullable AuthenticationParametersDpo authenticationParameters, @Nullable ServiceIdentityInfoDpo serviceIdentity, boolean validateUri) {
        this.connectionTypeCode = connectionTypeCode;
        this.uri = uri;
        this.authenticationParameters = authenticationParameters;
        this.serviceIdentity = serviceIdentity;
        if (validateUri) {
            this.validateUri(uri);
        }
    }

    public int getConnectionTypeCode() {
        return this.connectionTypeCode;
    }

    @JsonIgnore
    public ConnectionType getConnectionType() {
        return ConnectionType.fromCode(this.connectionTypeCode);
    }

    public String getUri() {
        return this.uri;
    }

    public AuthenticationParametersDpo getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    @Nullable
    public ServiceIdentityInfoDpo getServiceIdentity() {
        return this.serviceIdentity;
    }

    public String serialize() {
        try {
            return DEFAULT_MAPPER.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ConnectionConfigInfoDpo deserialize(@Nonnull String jsonStr) {
        try {
            return (ConnectionConfigInfoDpo)DEFAULT_MAPPER.readValue(jsonStr, ConnectionConfigInfoDpo.class);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("deserialize failed: " + ex.getMessage(), ex);
        }
    }

    protected void validateUri(String uri) {
        try {
            URI uriObj = URI.create(uri);
            if (this.connectionTypeCode == ConnectionType.HIVE.getCode() && uriObj.getScheme().equals("thrift")) {
                return;
            }
            URL uRL = uriObj.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException("Invalid remote URI: " + uri, e);
        }
    }

    public static ConnectionConfigInfoDpo fromConnectionConfigInfoModelWithSecrets(ConnectionConfigInfo connectionConfigurationModel, Map<String, SecretReference> secretReferences) {
        ConnectionConfigInfoDpo config = null;
        switch (connectionConfigurationModel.getConnectionType()) {
            case ICEBERG_REST: {
                IcebergRestConnectionConfigInfo icebergRestConfigModel = (IcebergRestConnectionConfigInfo)connectionConfigurationModel;
                AuthenticationParametersDpo authenticationParameters = AuthenticationParametersDpo.fromAuthenticationParametersModelWithSecrets(icebergRestConfigModel.getAuthenticationParameters(), secretReferences);
                config = new IcebergRestConnectionConfigInfoDpo(icebergRestConfigModel.getUri(), authenticationParameters, null, icebergRestConfigModel.getRemoteCatalogName());
                break;
            }
            case HADOOP: {
                HadoopConnectionConfigInfo hadoopConfigModel = (HadoopConnectionConfigInfo)connectionConfigurationModel;
                AuthenticationParametersDpo authenticationParameters = AuthenticationParametersDpo.fromAuthenticationParametersModelWithSecrets(hadoopConfigModel.getAuthenticationParameters(), secretReferences);
                config = new HadoopConnectionConfigInfoDpo(hadoopConfigModel.getUri(), authenticationParameters, null, hadoopConfigModel.getWarehouse());
                break;
            }
            case HIVE: {
                HiveConnectionConfigInfo hiveConfigModel = (HiveConnectionConfigInfo)connectionConfigurationModel;
                AuthenticationParametersDpo authenticationParameters = AuthenticationParametersDpo.fromAuthenticationParametersModelWithSecrets(hiveConfigModel.getAuthenticationParameters(), secretReferences);
                config = new HiveConnectionConfigInfoDpo(hiveConfigModel.getUri(), authenticationParameters, hiveConfigModel.getWarehouse(), null);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported connection type: " + String.valueOf(connectionConfigurationModel.getConnectionType()));
            }
        }
        return config;
    }

    public abstract ConnectionConfigInfoDpo withServiceIdentity(@Nonnull ServiceIdentityInfoDpo var1);

    public abstract ConnectionConfigInfo asConnectionConfigInfoModel(ServiceIdentityProvider var1);

    static {
        DEFAULT_MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        DEFAULT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

