/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.events.listeners.inmemory;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.service.events.listeners.PolarisPersistenceEventListener;
import org.apache.polaris.service.events.listeners.inmemory.InMemoryBufferEventListenerConfiguration;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="persistence-in-memory-buffer")
public class InMemoryBufferEventListener
extends PolarisPersistenceEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryBufferEventListener.class);
    @Inject
    CallContext callContext;
    @Inject
    Clock clock;
    @Inject
    MetaStoreManagerFactory metaStoreManagerFactory;
    @Inject
    InMemoryBufferEventListenerConfiguration configuration;
    @Context
    SecurityContext securityContext;
    @Context
    ContainerRequestContext requestContext;
    @VisibleForTesting
    final LoadingCache<String, UnicastProcessor<PolarisEvent>> processors = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(1L)).evictionListener((realmId, processor, cause) -> processor.onComplete()).build(this::createProcessor);

    @Override
    protected void processEvent(PolarisEvent event) {
        String realmId = this.callContext.getRealmContext().getRealmIdentifier();
        this.processEvent(realmId, event);
    }

    protected void processEvent(String realmId, PolarisEvent event) {
        UnicastProcessor processor = Objects.requireNonNull((UnicastProcessor)this.processors.get((Object)realmId));
        processor.onNext((Object)event);
    }

    @Override
    protected PolarisPersistenceEventListener.ContextSpecificInformation getContextSpecificInformation() {
        Principal principal = this.securityContext.getUserPrincipal();
        String principalName = principal == null ? null : principal.getName();
        return new PolarisPersistenceEventListener.ContextSpecificInformation(this.clock.millis(), principalName);
    }

    @Override
    @Nullable
    protected String getRequestId() {
        return (String)this.requestContext.getProperty("requestId");
    }

    @PreDestroy
    public void shutdown() {
        this.processors.asMap().values().forEach(UnicastProcessor::onComplete);
        this.processors.invalidateAll();
    }

    protected UnicastProcessor<PolarisEvent> createProcessor(String realmId) {
        UnicastProcessor processor = UnicastProcessor.create();
        processor.emitOn((Executor)Infrastructure.getDefaultWorkerPool()).group().intoLists().of(this.configuration.maxBufferSize(), this.configuration.bufferTime()).subscribe().with(events -> this.flush(realmId, (List<PolarisEvent>)events), error -> this.onProcessorError(realmId, (Throwable)error));
        return processor;
    }

    @Retry(maxRetries=5, delay=1000L, jitter=100L)
    @Fallback(fallbackMethod="onFlushError")
    protected void flush(String realmId, List<PolarisEvent> events) {
        RealmContext realmContext = () -> realmId;
        PolarisMetaStoreManager metaStoreManager = this.metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
        BasePersistence basePersistence = this.metaStoreManagerFactory.getOrCreateSession(realmContext);
        PolarisCallContext callContext = new PolarisCallContext(realmContext, basePersistence);
        metaStoreManager.writeEvents(callContext, events);
    }

    protected void onFlushError(String realmId, List<PolarisEvent> events, Throwable error) {
        LOGGER.error("Failed to persist {} events for realm '{}'", new Object[]{events.size(), realmId, error});
    }

    protected void onProcessorError(String realmId, Throwable error) {
        LOGGER.error("Unexpected error while processing events for realm '{}'; some events may have been dropped", (Object)realmId, (Object)error);
        this.processors.invalidate((Object)realmId);
    }
}

