/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.identity;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.apache.polaris.core.admin.model.AwsIamServiceIdentityInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import org.apache.polaris.core.identity.ServiceIdentityType;
import org.apache.polaris.core.identity.credential.AwsIamServiceIdentityCredential;
import org.apache.polaris.core.secrets.SecretReference;
import org.apache.polaris.service.identity.ResolvableServiceIdentityConfiguration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public interface AwsIamServiceIdentityConfiguration
extends ResolvableServiceIdentityConfiguration {
    public String iamArn();

    public Optional<String> accessKeyId();

    public Optional<String> secretAccessKey();

    public Optional<String> sessionToken();

    @Override
    default public ServiceIdentityType getType() {
        return ServiceIdentityType.AWS_IAM;
    }

    default public Optional<AwsIamServiceIdentityInfo> asServiceIdentityInfoModel() {
        if (this.iamArn() == null) {
            return Optional.empty();
        }
        return Optional.of(AwsIamServiceIdentityInfo.builder().setIdentityType(ServiceIdentityInfo.IdentityTypeEnum.AWS_IAM).setIamArn(this.iamArn()).build());
    }

    default public Optional<AwsIamServiceIdentityCredential> asServiceIdentityCredential(@Nonnull SecretReference secretReference) {
        return Optional.of(new AwsIamServiceIdentityCredential(secretReference, this.iamArn(), this.awsCredentialsProvider()));
    }

    @Nonnull
    default public AwsCredentialsProvider awsCredentialsProvider() {
        if (this.accessKeyId().isPresent() && this.secretAccessKey().isPresent()) {
            if (this.sessionToken().isPresent()) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)this.accessKeyId().get(), (String)this.secretAccessKey().get(), (String)this.sessionToken().get()));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKeyId().get(), (String)this.secretAccessKey().get()));
        }
        return DefaultCredentialsProvider.builder().build();
    }

    public static AwsIamServiceIdentityConfiguration defaultConfiguration() {
        return new AwsIamServiceIdentityConfiguration(){

            @Override
            public String iamArn() {
                return null;
            }

            @Override
            public Optional<String> accessKeyId() {
                return Optional.empty();
            }

            @Override
            public Optional<String> secretAccessKey() {
                return Optional.empty();
            }

            @Override
            public Optional<String> sessionToken() {
                return Optional.empty();
            }
        };
    }
}

