/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.ProxyConfiguration;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;

class UrlConnectionHttpClientConfigurations {
    private Long httpClientUrlConnectionConnectionTimeoutMs;
    private Long httpClientUrlConnectionSocketTimeoutMs;
    private String proxyEndpoint;

    private UrlConnectionHttpClientConfigurations() {
    }

    public <T extends AwsSyncClientBuilder> void configureHttpClientBuilder(T awsClientBuilder) {
        UrlConnectionHttpClient.Builder urlConnectionHttpClientBuilder = UrlConnectionHttpClient.builder();
        this.configureUrlConnectionHttpClientBuilder(urlConnectionHttpClientBuilder);
        awsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)urlConnectionHttpClientBuilder);
    }

    private void initialize(Map<String, String> httpClientProperties) {
        this.httpClientUrlConnectionConnectionTimeoutMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, (String)"http-client.urlconnection.connection-timeout-ms");
        this.httpClientUrlConnectionSocketTimeoutMs = PropertyUtil.propertyAsNullableLong(httpClientProperties, (String)"http-client.urlconnection.socket-timeout-ms");
        this.proxyEndpoint = PropertyUtil.propertyAsString(httpClientProperties, (String)"http-client.proxy-endpoint", null);
    }

    @VisibleForTesting
    void configureUrlConnectionHttpClientBuilder(UrlConnectionHttpClient.Builder urlConnectionHttpClientBuilder) {
        if (this.httpClientUrlConnectionConnectionTimeoutMs != null) {
            urlConnectionHttpClientBuilder.connectionTimeout(Duration.ofMillis(this.httpClientUrlConnectionConnectionTimeoutMs));
        }
        if (this.httpClientUrlConnectionSocketTimeoutMs != null) {
            urlConnectionHttpClientBuilder.socketTimeout(Duration.ofMillis(this.httpClientUrlConnectionSocketTimeoutMs));
        }
        if (this.proxyEndpoint != null) {
            urlConnectionHttpClientBuilder.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(this.proxyEndpoint)).build());
        }
    }

    public static UrlConnectionHttpClientConfigurations create(Map<String, String> httpClientProperties) {
        UrlConnectionHttpClientConfigurations configurations = new UrlConnectionHttpClientConfigurations();
        configurations.initialize(httpClientProperties);
        return configurations;
    }
}

