/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionOperationProcedure;
import org.apache.iotdb.confignode.procedure.state.NotifyRegionMigrationState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyRegionMigrationProcedure
extends RegionOperationProcedure<NotifyRegionMigrationState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyRegionMigrationProcedure.class);
    private boolean isStart;

    public NotifyRegionMigrationProcedure() {
    }

    public NotifyRegionMigrationProcedure(TConsensusGroupId consensusGroupId, boolean isStart) {
        super(consensusGroupId);
        this.isStart = isStart;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, NotifyRegionMigrationState state) throws InterruptedException {
        if (this.regionId == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            LOGGER.info("[pid{}][NotifyRegionMigration] started, region id is {}.", (Object)this.getProcId(), (Object)this.regionId);
            env.notifyRegionMigrationToAllDataNodes(this.regionId, this.isStart);
        }
        catch (Exception e) {
            LOGGER.error("[pid{}][NotifyRegionMigration] state {} failed", new Object[]{this.getProcId(), state, e});
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOGGER.info("[pid{}][NotifyRegionMigration] state {} complete", (Object)this.getProcId(), (Object)state);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, NotifyRegionMigrationState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected NotifyRegionMigrationState getState(int stateId) {
        return NotifyRegionMigrationState.values()[stateId];
    }

    @Override
    protected int getStateId(NotifyRegionMigrationState state) {
        return state.ordinal();
    }

    @Override
    protected NotifyRegionMigrationState getInitialState() {
        return NotifyRegionMigrationState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.NOTIFY_REGION_MIGRATION_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        stream.writeBoolean(this.isStart);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
            this.isStart = byteBuffer.get() != 0;
        }
        catch (ThriftSerDeException e) {
            LOGGER.error("Error in deserialize {}", this.getClass(), (Object)e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotifyRegionMigrationProcedure)) {
            return false;
        }
        NotifyRegionMigrationProcedure procedure = (NotifyRegionMigrationProcedure)obj;
        return this.regionId.equals(procedure.regionId) && this.isStart == procedure.isStart;
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.isStart);
    }

    @Override
    public String toString() {
        return "NotifyRegionMigrationProcedure{regionId=" + this.regionId + ", isStart=" + this.isStart + '}';
    }
}

