/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.AbstractSessionMessageQueue;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.unsafequeues.Queue;
import io.moquette.broker.unsafequeues.QueueException;
import io.moquette.persistence.SegmentedPersistentQueueSerDes;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPersistentQueue
extends AbstractSessionMessageQueue<SessionRegistry.EnqueuedMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentPersistentQueue.class);
    private final Queue segmentedQueue;
    private final SegmentedPersistentQueueSerDes serdes = new SegmentedPersistentQueueSerDes();

    public SegmentPersistentQueue(Queue segmentedQueue) {
        this.segmentedQueue = segmentedQueue;
    }

    @Override
    public void enqueue(SessionRegistry.EnqueuedMessage message) {
        LOG.debug("Adding message {}", (Object)message);
        this.checkEnqueuePreconditions(message);
        ByteBuffer payload = this.serdes.toBytes(message);
        try {
            this.segmentedQueue.enqueue(payload);
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SessionRegistry.EnqueuedMessage dequeue() {
        Optional<ByteBuffer> dequeue;
        this.checkDequeuePreconditions();
        try {
            dequeue = this.segmentedQueue.dequeue();
        }
        catch (QueueException e) {
            throw new RuntimeException(e);
        }
        if (!dequeue.isPresent()) {
            LOG.debug("No data pulled out from the queue");
            return null;
        }
        ByteBuffer content = dequeue.get();
        SessionRegistry.EnqueuedMessage message = this.serdes.fromBytes(content);
        LOG.debug("Retrieved message {}", (Object)message);
        return message;
    }

    @Override
    public boolean isEmpty() {
        return this.segmentedQueue.isEmpty();
    }

    @Override
    public void closeAndPurge() {
        this.closed = true;
    }
}

