/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import org.eclipse.milo.opcua.stack.core.UaException;

public enum MessageType {
    Hello,
    Acknowledge,
    Error,
    OpenSecureChannel,
    CloseSecureChannel,
    SecureMessage;

    private static final int HEL = 4998472;
    private static final int ACK = 4932417;
    private static final int ERR = 0x525245;
    private static final int OPN = 5132367;
    private static final int CLO = 5196867;
    private static final int MSG = 4674381;

    public static int toMediumInt(MessageType messageType) throws UaException {
        switch (messageType) {
            case Hello: {
                return 4998472;
            }
            case Acknowledge: {
                return 4932417;
            }
            case Error: {
                return 0x525245;
            }
            case OpenSecureChannel: {
                return 5132367;
            }
            case CloseSecureChannel: {
                return 5196867;
            }
            case SecureMessage: {
                return 4674381;
            }
        }
        throw new UaException(2155741184L, "unknown message type: " + (Object)((Object)messageType));
    }

    public static MessageType fromMediumInt(int messageType) throws UaException {
        switch (messageType) {
            case 4998472: {
                return Hello;
            }
            case 4932417: {
                return Acknowledge;
            }
            case 0x525245: {
                return Error;
            }
            case 5132367: {
                return OpenSecureChannel;
            }
            case 5196867: {
                return CloseSecureChannel;
            }
            case 4674381: {
                return SecureMessage;
            }
        }
        throw new UaException(2155741184L, "unknown message type: " + messageType);
    }
}

