/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import java.util.ArrayList;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ColumnInjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.RawDataAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;

public class ColumnInjectionPushDown
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Analysis analysis, MPPQueryContext context) {
        if (analysis.getStatement().getType() != StatementType.QUERY) {
            return plan;
        }
        QueryStatement queryStatement = analysis.getQueryStatement();
        if (queryStatement.isGroupByTime() && queryStatement.isOutputEndTime()) {
            return plan.accept(new Rewriter(), null);
        }
        return plan;
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitPlan(PlanNode node, Void context) {
            return node;
        }

        @Override
        public PlanNode visitSingleChildProcess(SingleChildProcessNode node, Void context) {
            PlanNode rewrittenChild = node.getChild().accept(this, context);
            node.setChild(rewrittenChild);
            return node;
        }

        @Override
        public PlanNode visitMultiChildProcess(MultiChildProcessNode node, Void context) {
            ArrayList<PlanNode> rewrittenChildren = new ArrayList<PlanNode>();
            for (PlanNode child : node.getChildren()) {
                rewrittenChildren.add(child.accept(this, context));
            }
            node.setChildren(rewrittenChildren);
            return node;
        }

        @Override
        public PlanNode visitTwoChildProcess(TwoChildProcessNode node, Void context) {
            node.setLeftChild(node.getLeftChild().accept(this, context));
            node.setRightChild(node.getRightChild().accept(this, context));
            return node;
        }

        @Override
        public PlanNode visitColumnInject(ColumnInjectNode node, Void context) {
            PlanNode child = node.getChild();
            boolean columnInjectPushDown = this.doPushDown(node, child);
            if (columnInjectPushDown) {
                return child;
            }
            return node;
        }

        private boolean doPushDown(PlanNode node, PlanNode child) {
            boolean columnInjectPushDown = true;
            if (child instanceof SeriesAggregationSourceNode) {
                ((SeriesAggregationSourceNode)child).setOutputEndTime(true);
            } else if (child instanceof SlidingWindowAggregationNode) {
                ((SlidingWindowAggregationNode)child).setOutputEndTime(true);
            } else if (child instanceof AggregationNode) {
                ((AggregationNode)child).setOutputEndTime(true);
            } else if (child instanceof RawDataAggregationNode) {
                ((RawDataAggregationNode)child).setOutputEndTime(true);
            } else {
                if (child instanceof ProjectNode) {
                    ProjectNode projectNode = (ProjectNode)child;
                    boolean pushDownToChild = this.doPushDown(child, projectNode.getChild());
                    if (pushDownToChild) {
                        projectNode.setOutputColumnNames(node.getOutputColumnNames());
                    }
                    return pushDownToChild;
                }
                columnInjectPushDown = false;
            }
            return columnInjectPushDown;
        }
    }
}

