/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.statement;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeTabletMemoryBlock;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.tsfile.utils.RamUsageEstimator;

public class PipeStatementInsertionEvent
extends PipeInsertionEvent
implements ReferenceTrackableEvent,
AutoCloseable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PipeStatementInsertionEvent.class);
    private InsertBaseStatement statement;
    private volatile ProgressIndex progressIndex;
    private boolean needToReport;
    private final PipeTabletMemoryBlock allocatedMemoryBlock;

    public PipeStatementInsertionEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, Boolean isTableModelEvent, String databaseNameFromDataRegion, InsertBaseStatement statement) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, userName, skipIfNoPrivileges, Long.MIN_VALUE, Long.MAX_VALUE, isTableModelEvent, databaseNameFromDataRegion, null, null);
        this.statement = statement;
        this.allocatedMemoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForTabletWithRetry(0L);
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        PipeDataNodeResourceManager.memory().forceResize(this.allocatedMemoryBlock, this.statement.ramBytesUsed() + INSTANCE_SIZE);
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeSinglePipeMetrics.getInstance().increaseRawTabletEventCount(this.pipeName, this.creationTime);
        }
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        if (Objects.nonNull(this.pipeName)) {
            PipeDataNodeSinglePipeMetrics.getInstance().decreaseRawTabletEventCount(this.pipeName, this.creationTime);
        }
        this.allocatedMemoryBlock.close();
        this.statement = null;
        return true;
    }

    public void bindProgressIndex(ProgressIndex progressIndex) {
        if (Objects.nonNull(progressIndex)) {
            this.markAsNeedToReport();
        }
        this.progressIndex = progressIndex;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        throw new UnsupportedOperationException("shallowCopySelfAndBindPipeTaskMetaForProgressReport() is not supported!");
    }

    public boolean isGeneratedByPipe() {
        return false;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        throw new UnsupportedOperationException("mayEventTimeOverlappedWithTimeRange() is not supported!");
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        throw new UnsupportedOperationException("mayEventPathsOverlappedWithPattern() is not supported!");
    }

    public void markAsNeedToReport() {
        this.needToReport = true;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public String toString() {
        return String.format("PipeStatementInsertionEvent{statement=%s, needToReport=%s, allocatedMemoryBlock=%s}", this.statement, this.needToReport, this.allocatedMemoryBlock) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeStatementInsertionEvent{statement=%s, needToReport=%s, allocatedMemoryBlock=%s}", this.statement, this.needToReport, this.allocatedMemoryBlock) + " - " + super.coreReportMessage();
    }

    protected void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeStatementInsertionEventResource(this.isReleased, this.referenceCount, this.allocatedMemoryBlock);
    }

    @Override
    public void close() throws Exception {
    }

    private static class PipeStatementInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final PipeTabletMemoryBlock allocatedMemoryBlock;

        private PipeStatementInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, PipeTabletMemoryBlock allocatedMemoryBlock) {
            super(isReleased, referenceCount);
            this.allocatedMemoryBlock = allocatedMemoryBlock;
        }

        protected void finalizeResource() {
            this.allocatedMemoryBlock.close();
        }
    }
}

