/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSizeStore;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSpaceQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeSpaceQuotaManager.class);
    private ConcurrentMap<String, TSpaceQuota> spaceQuotaLimit;
    private ConcurrentMap<String, TSpaceQuota> spaceQuotaUsage;
    private DataNodeSizeStore dataNodeSizeStore;

    public DataNodeSpaceQuotaManager() {
        this.spaceQuotaLimit = new ConcurrentHashMap<String, TSpaceQuota>();
        this.spaceQuotaUsage = new ConcurrentHashMap<String, TSpaceQuota>();
        this.dataNodeSizeStore = new DataNodeSizeStore();
        this.recover();
    }

    public DataNodeSpaceQuotaManager(ConcurrentMap<String, TSpaceQuota> spaceQuotaLimit, ConcurrentMap<String, TSpaceQuota> spaceQuotaUsage) {
        this.spaceQuotaLimit = spaceQuotaLimit;
        this.spaceQuotaUsage = spaceQuotaUsage;
    }

    public static DataNodeSpaceQuotaManager getInstance() {
        return DataNodeSpaceQuotaManagerHolder.INSTANCE;
    }

    public TSStatus setSpaceQuota(TSetSpaceQuotaReq req) {
        for (String database : req.getDatabase()) {
            this.spaceQuotaUsage.put(database, new TSpaceQuota());
            this.spaceQuotaLimit.put(database, req.getSpaceLimit());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    private void recover() {
        TSpaceQuotaResp spaceQuota = ClusterConfigTaskExecutor.getInstance().getSpaceQuota();
        if (spaceQuota.getStatus() != null) {
            if (spaceQuota.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && spaceQuota.getSpaceQuota() != null) {
                for (String database : spaceQuota.getSpaceQuota().keySet()) {
                    this.spaceQuotaUsage.put(database, new TSpaceQuota());
                    this.spaceQuotaLimit.put(database, (TSpaceQuota)spaceQuota.getSpaceQuota().get(database));
                }
            }
            LOGGER.info("Space quota limit restore succeeded, limit: {}.", this.spaceQuotaLimit);
        } else {
            LOGGER.error("Space quota limit restore failed, limit: {}.", this.spaceQuotaLimit);
        }
    }

    public boolean checkDeviceLimit(String database) {
        database = "root." + database;
        TSpaceQuota spaceQuota = (TSpaceQuota)this.spaceQuotaLimit.get(database);
        return spaceQuota == null || spaceQuota.getDeviceNum() == 0L || spaceQuota.getDeviceNum() == -1L || spaceQuota.getDeviceNum() - ((TSpaceQuota)this.spaceQuotaUsage.get(database)).getDeviceNum() > 0L;
    }

    public void updateSpaceQuotaUsage(Map<String, TSpaceQuota> spaceQuotaUsage) {
        if (Objects.nonNull(spaceQuotaUsage)) {
            this.spaceQuotaUsage.putAll(spaceQuotaUsage);
        }
    }

    public boolean checkTimeSeriesNum(String database) {
        database = "root." + database;
        TSpaceQuota spaceQuota = (TSpaceQuota)this.spaceQuotaLimit.get(database);
        return spaceQuota == null || spaceQuota.getTimeserieNum() == 0L || spaceQuota.getTimeserieNum() == -1L || spaceQuota.getTimeserieNum() - ((TSpaceQuota)this.spaceQuotaUsage.get(database)).getTimeserieNum() > 0L;
    }

    public boolean checkRegionDisk(String database) {
        TSpaceQuota spaceQuota = (TSpaceQuota)this.spaceQuotaLimit.get(database);
        return spaceQuota == null || spaceQuota.getDiskSize() == 0L || spaceQuota.getDiskSize() == -1L || spaceQuota.getDiskSize() - ((TSpaceQuota)this.spaceQuotaUsage.get(database)).getDiskSize() > 0L;
    }

    public void setDataRegionIds(List<Integer> dataRegionIds) {
        this.dataNodeSizeStore.setDataRegionIds(dataRegionIds);
    }

    public Map<Integer, Long> getRegionDisk() {
        return this.dataNodeSizeStore.getDataRegionDisk();
    }

    private static class DataNodeSpaceQuotaManagerHolder {
        private static final DataNodeSpaceQuotaManager INSTANCE = new DataNodeSpaceQuotaManager();

        private DataNodeSpaceQuotaManagerHolder() {
        }
    }
}

