/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SortOrder;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.GroupNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.PatternRecognitionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class ImplementPatternRecognition
implements Rule<PatternRecognitionNode> {
    private static final Pattern<PatternRecognitionNode> PATTERN = Patterns.patternRecognition();

    @Override
    public Pattern<PatternRecognitionNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(PatternRecognitionNode node, Captures captures, Rule.Context context) {
        PlanNode childRef = (PlanNode)Iterables.getOnlyElement(node.getChildren());
        PlanNode underlying = context.getLookup().resolve(childRef);
        ArrayList<Symbol> sortSymbols = new ArrayList<Symbol>();
        HashMap<Symbol, SortOrder> sortOrderings = new HashMap<Symbol, SortOrder>();
        for (Symbol symbol : node.getPartitionBy()) {
            sortSymbols.add(symbol);
            sortOrderings.put(symbol, SortOrder.ASC_NULLS_LAST);
        }
        int sortKeyOffset = sortSymbols.size();
        node.getOrderingScheme().ifPresent(scheme -> scheme.getOrderBy().forEach(symbol -> {
            if (!sortOrderings.containsKey(symbol)) {
                sortSymbols.add((Symbol)symbol);
                sortOrderings.put((Symbol)symbol, scheme.getOrdering((Symbol)symbol));
            }
        }));
        if (sortSymbols.isEmpty() || underlying instanceof GroupNode) {
            return Rule.Result.empty();
        }
        OrderingScheme orderingScheme = new OrderingScheme(sortSymbols, sortOrderings);
        GroupNode wrapped = new GroupNode(context.getIdAllocator().genPlanNodeId(), childRef, orderingScheme, sortKeyOffset);
        PatternRecognitionNode rewritten = new PatternRecognitionNode(node.getPlanNodeId(), wrapped, node.getPartitionBy(), node.getOrderingScheme(), node.getHashSymbol(), node.getMeasures(), node.getRowsPerMatch(), node.getSkipToLabels(), node.getSkipToPosition(), node.getPattern(), node.getVariableDefinitions());
        return Rule.Result.ofPlanNode(rewritten);
    }
}

