/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowClusterTask
implements IConfigTask {
    private final ShowClusterStatement showClusterStatement;

    public ShowClusterTask(ShowClusterStatement showClusterStatement) {
        this.showClusterStatement = showClusterStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showCluster(this.showClusterStatement);
    }

    private static void buildTsBlock(TsBlockBuilder builder, int nodeId, String nodeType, String nodeStatus, String hostAddress, int port, TNodeVersionInfo versionInfo) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeInt(nodeId);
        if (nodeType == null) {
            builder.getColumnBuilder(1).appendNull();
        } else {
            builder.getColumnBuilder(1).writeBinary(new Binary(nodeType, TSFileConfig.STRING_CHARSET));
        }
        if (nodeStatus == null) {
            builder.getColumnBuilder(2).appendNull();
        } else {
            builder.getColumnBuilder(2).writeBinary(new Binary(nodeStatus, TSFileConfig.STRING_CHARSET));
        }
        if (hostAddress == null) {
            builder.getColumnBuilder(3).appendNull();
        } else {
            builder.getColumnBuilder(3).writeBinary(new Binary(hostAddress, TSFileConfig.STRING_CHARSET));
        }
        builder.getColumnBuilder(4).writeInt(port);
        if (versionInfo == null || versionInfo.getVersion() == null) {
            builder.getColumnBuilder(5).appendNull();
        } else {
            builder.getColumnBuilder(5).writeBinary(new Binary(versionInfo.getVersion(), TSFileConfig.STRING_CHARSET));
        }
        if (versionInfo == null || versionInfo.getBuildInfo() == null) {
            builder.getColumnBuilder(6).appendNull();
        } else {
            builder.getColumnBuilder(6).writeBinary(new Binary(versionInfo.getBuildInfo(), TSFileConfig.STRING_CHARSET));
        }
        builder.declarePosition();
    }

    public static void buildTsBlock(TShowClusterResp clusterNodeInfos, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showClusterColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        clusterNodeInfos.getConfigNodeList().forEach(e -> ShowClusterTask.buildTsBlock(builder, e.getConfigNodeId(), "ConfigNode", (String)clusterNodeInfos.getNodeStatus().get(e.getConfigNodeId()), e.getInternalEndPoint().getIp(), e.getInternalEndPoint().getPort(), (TNodeVersionInfo)clusterNodeInfos.getNodeVersionInfo().get(e.getConfigNodeId())));
        clusterNodeInfos.getDataNodeList().forEach(e -> ShowClusterTask.buildTsBlock(builder, e.getDataNodeId(), "DataNode", (String)clusterNodeInfos.getNodeStatus().get(e.getDataNodeId()), e.getInternalEndPoint().getIp(), e.getInternalEndPoint().getPort(), (TNodeVersionInfo)clusterNodeInfos.getNodeVersionInfo().get(e.getDataNodeId())));
        if (clusterNodeInfos.getAiNodeList() != null) {
            clusterNodeInfos.getAiNodeList().forEach(e -> ShowClusterTask.buildTsBlock(builder, e.getAiNodeId(), "AINode", (String)clusterNodeInfos.getNodeStatus().get(e.getAiNodeId()), e.getInternalEndPoint().getIp(), e.getInternalEndPoint().getPort(), (TNodeVersionInfo)clusterNodeInfos.getNodeVersionInfo().get(e.getAiNodeId())));
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowClusterHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

