/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.Transformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;

public abstract class UnaryTransformer
extends Transformer {
    protected final LayerReader layerReader;
    protected final TSDataType layerReaderDataType;
    protected final boolean isLayerReaderConstant;

    protected UnaryTransformer(LayerReader layerReader) {
        this.layerReader = layerReader;
        this.layerReaderDataType = layerReader.getDataTypes()[0];
        this.isLayerReaderConstant = layerReader.isConstantPointReader();
    }

    @Override
    public final boolean isConstantPointReader() {
        return this.isLayerReaderConstant;
    }

    @Override
    public YieldableState yieldValue() throws Exception {
        YieldableState state = this.layerReader.yield();
        if (!YieldableState.YIELDABLE.equals((Object)state)) {
            return state;
        }
        Column[] columns = this.layerReader.current();
        this.cachedColumns = this.transform(columns);
        this.layerReader.consumedAll();
        return YieldableState.YIELDABLE;
    }

    protected Column[] transform(Column[] columns) throws QueryProcessException, IOException {
        int count = columns[0].getPositionCount();
        TSDataType dataType = this.getDataTypes()[0];
        ColumnBuilder builder = TypeUtils.initColumnBuilder(dataType, count);
        this.transform(columns, builder);
        Column valueColumn = builder.build();
        Column timeColumn = columns[1];
        return new Column[]{valueColumn, timeColumn};
    }

    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
    }
}

