/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.queue.listening;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractSerializableListeningQueue;
import org.apache.iotdb.commons.pipe.datastructure.queue.serializer.QueueSerializerType;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipeListeningQueue
extends AbstractSerializableListeningQueue<Event> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPipeListeningQueue.class);
    private final Pair<Long, List<PipeSnapshotEvent>> queueTailIndex2SnapshotsCache = new Pair((Object)Long.MIN_VALUE, new ArrayList());

    protected AbstractPipeListeningQueue() {
        super(QueueSerializerType.PLAIN);
    }

    protected synchronized void tryListen(EnrichedEvent event) {
        if (super.tryListen(event)) {
            event.increaseReferenceCount(AbstractPipeListeningQueue.class.getName());
        }
    }

    protected synchronized void tryListen(List<PipeSnapshotEvent> events) {
        if (!this.isClosed.get()) {
            this.clearSnapshots();
            this.queueTailIndex2SnapshotsCache.setLeft((Object)this.queue.getTailIndex());
            events.forEach(event -> event.increaseReferenceCount(AbstractPipeListeningQueue.class.getName()));
            this.queueTailIndex2SnapshotsCache.setRight(events);
            LOGGER.info("Pipe listening queue snapshot cache is updated: {}", this.queueTailIndex2SnapshotsCache);
        }
    }

    public synchronized Pair<Long, List<PipeSnapshotEvent>> findAvailableSnapshots() {
        if ((Long)this.queueTailIndex2SnapshotsCache.getLeft() < this.queue.getTailIndex() - PipeConfig.getInstance().getPipeListeningQueueTransferSnapshotThreshold()) {
            this.clearSnapshots();
        }
        return this.queueTailIndex2SnapshotsCache;
    }

    @Override
    public synchronized long removeBefore(long newFirstIndex) {
        long result = super.removeBefore(newFirstIndex);
        if ((Long)this.queueTailIndex2SnapshotsCache.getLeft() < result) {
            this.clearSnapshots();
        }
        return result;
    }

    private synchronized void clearSnapshots() {
        this.queueTailIndex2SnapshotsCache.setLeft((Object)Long.MIN_VALUE);
        ((List)this.queueTailIndex2SnapshotsCache.getRight()).forEach(event -> event.decreaseReferenceCount(AbstractPipeListeningQueue.class.getName(), false));
        this.queueTailIndex2SnapshotsCache.setRight(new ArrayList());
    }

    @Override
    public synchronized void close() {
        this.clearSnapshots();
        super.close();
    }

    @Override
    protected void releaseResource(Event event) {
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).decreaseReferenceCount(AbstractPipeListeningQueue.class.getName(), false);
        }
    }
}

