/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongCharToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;

public abstract class AbstractUnmodifiableCharCollection
implements MutableCharCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharCollection collection;

    protected AbstractUnmodifiableCharCollection(MutableCharCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractUnmodifiableCharCollection on a null collection");
        }
        this.collection = collection;
    }

    protected MutableCharCollection getCharCollection() {
        return this.collection;
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean contains(char value) {
        return this.collection.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.collection.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.collection.containsAll(source);
    }

    @Override
    public boolean containsAny(char ... source) {
        return this.collection.containsAny(source);
    }

    @Override
    public boolean containsAny(CharIterable source) {
        return this.collection.containsAny(source);
    }

    @Override
    public boolean containsNone(char ... source) {
        return this.collection.containsNone(source);
    }

    @Override
    public boolean containsNone(CharIterable source) {
        return this.collection.containsNone(source);
    }

    @Override
    public boolean add(char newItem) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(char ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean addAll(CharIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean remove(char value) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeIf(CharPredicate predicate) {
        throw new UnsupportedOperationException("Cannot call removeIf() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(CharIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean removeAll(char ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(CharIterable source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public boolean retainAll(char ... source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharIterator charIterator() {
        return new UnmodifiableCharIterator(this.collection.charIterator());
    }

    @Override
    public void each(CharProcedure procedure) {
        this.collection.forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.collection.count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    @Override
    public MutableCharCollection select(CharPredicate predicate) {
        return this.collection.select(predicate);
    }

    @Override
    public MutableCharCollection reject(CharPredicate predicate) {
        return this.collection.reject(predicate);
    }

    @Override
    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.collection.collect((CharToObjectFunction)function);
    }

    @Override
    public MutableCharCollection with(char element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharCollection without(char element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharCollection withAll(CharIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharCollection withoutAll(CharIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableCharCollection asUnmodifiable() {
        return this;
    }

    @Override
    public MutableCharCollection asSynchronized() {
        return new SynchronizedCharCollection(this);
    }

    @Override
    public ImmutableCharCollection toImmutable() {
        return this.collection.toImmutable();
    }

    @Override
    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter(this);
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.collection.sum();
    }

    @Override
    public char max() {
        return this.collection.max();
    }

    @Override
    public char min() {
        return this.collection.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.collection.minIfEmpty(defaultValue);
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.collection.maxIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.collection.average();
    }

    @Override
    public double median() {
        return this.collection.median();
    }

    @Override
    public MutableCharList toSortedList() {
        return this.collection.toSortedList();
    }

    @Override
    public char[] toSortedArray() {
        return this.collection.toSortedArray();
    }

    @Override
    public char[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public char[] toArray(char[] target) {
        return this.collection.toArray(target);
    }

    @Override
    public String toString() {
        return this.collection.toString();
    }

    @Override
    public String makeString() {
        return this.collection.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableCharList toList() {
        return this.collection.toList();
    }

    @Override
    public MutableCharSet toSet() {
        return this.collection.toSet();
    }

    @Override
    public MutableCharBag toBag() {
        return this.collection.toBag();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return this.collection.injectInto(injectedValue, function);
    }

    @Override
    public long reduce(LongCharToLongFunction accumulator) {
        return this.collection.reduce(accumulator);
    }

    @Override
    public long reduceIfEmpty(LongCharToLongFunction accumulator, long defaultValue) {
        return this.collection.reduceIfEmpty(accumulator, defaultValue);
    }

    @Override
    public RichIterable<CharIterable> chunk(int size) {
        return this.collection.chunk(size);
    }
}

