/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.AutoCloseInputStream;

public class LazyFileInputStream
extends AutoCloseInputStream {
    protected final FileDescriptor fd;
    protected final File file;
    protected boolean opened;

    public LazyFileInputStream(File file) throws FileNotFoundException {
        super((InputStream)null);
        if (!file.canRead()) {
            throw new FileNotFoundException(file.getPath());
        }
        this.file = file;
        this.fd = null;
    }

    public LazyFileInputStream(FileDescriptor fd) {
        super((InputStream)null);
        this.file = null;
        this.fd = fd;
    }

    public LazyFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    protected void open() throws IOException {
        if (!this.opened) {
            this.opened = true;
            this.in = this.fd != null ? new FileInputStream(this.fd) : new FileInputStream(this.file);
        }
    }

    @Override
    public int read() throws IOException {
        this.open();
        return super.read();
    }

    @Override
    public int available() throws IOException {
        this.open();
        return super.available();
    }

    @Override
    public void close() throws IOException {
        this.opened = true;
        if (this.in != null) {
            super.close();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.open();
        super.reset();
    }

    @Override
    public boolean markSupported() {
        try {
            this.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
        return super.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString());
        }
        super.mark(readlimit);
    }

    @Override
    public long skip(long n) throws IOException {
        this.open();
        return super.skip(n);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.open();
        return super.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.open();
        return super.read(b, off, len);
    }
}

