/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Node;
import javax.jcr.PropertyType;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.core.AbstractSetProperty;

public class SetMultivalueProperty
extends AbstractSetProperty {
    private static Log log = LogFactory.getLog(SetMultivalueProperty.class);
    private String regExpKey = "regExp";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String regExp = (String)ctx.get(this.regExpKey);
        String value = (String)ctx.get(this.valueKey);
        String name = (String)ctx.get(this.nameKey);
        String type = (String)ctx.get(this.typeKey);
        String parent = (String)ctx.get(this.parentPathKey);
        Node node = CommandHelper.getNode(ctx, parent);
        if (log.isDebugEnabled()) {
            log.debug("setting multivalue property from node at " + node.getPath() + ". regexp=" + regExp + " value=" + value + " property=" + name);
        }
        String[] values = value.split(regExp);
        if (type == null) {
            node.setProperty(name, values);
        } else {
            node.setProperty(name, values, PropertyType.valueFromName(type));
        }
        return false;
    }

    public String getRegExpKey() {
        return this.regExpKey;
    }

    public void setRegExpKey(String regExpKey) {
        this.regExpKey = regExpKey;
    }
}

