/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Node;
import javax.jcr.PropertyType;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;
import org.apache.jackrabbit.standalone.cli.core.AbstractSetProperty;

public class SetProperty
extends AbstractSetProperty {
    private static Log log = LogFactory.getLog(SetProperty.class);

    @Override
    public boolean execute(Context ctx) throws Exception {
        String value = (String)ctx.get(this.valueKey);
        String name = (String)ctx.get(this.nameKey);
        String propertyType = (String)ctx.get(this.typeKey);
        String parent = (String)ctx.get(this.parentPathKey);
        Node node = CommandHelper.getNode(ctx, parent);
        if (log.isDebugEnabled()) {
            log.debug("setting property to node at " + node.getPath() + ". property=" + name + " value=" + value);
        }
        if (propertyType == null) {
            node.setProperty(name, value);
        } else {
            node.setProperty(name, value, PropertyType.valueFromName(propertyType));
        }
        return false;
    }
}

