/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import junit.framework.Assert;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;

public class RawFieldTest {
    @Test
    public void testPrivateConstructor() throws Exception {
        String s = "raw: stuff;\r\n  more stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField field = new RawField(raw, 3, "raw", null);
        Assert.assertSame((Object)raw, (Object)field.getRaw());
        Assert.assertEquals((String)"raw", (String)field.getName());
        Assert.assertEquals((String)"stuff;  more stuff", (String)field.getBody());
        Assert.assertEquals((String)s, (String)field.toString());
    }

    @Test
    public void testPublicConstructor() throws Exception {
        RawField field1 = new RawField("raw", "stuff");
        Assert.assertNull((Object)field1.getRaw());
        Assert.assertEquals((String)"raw", (String)field1.getName());
        Assert.assertEquals((String)"stuff", (String)field1.getBody());
        Assert.assertEquals((String)"raw: stuff", (String)field1.toString());
        RawField field2 = new RawField("raw", "any");
        Assert.assertNull((Object)field2.getRaw());
        Assert.assertEquals((String)"raw", (String)field2.getName());
        Assert.assertEquals((String)"any", (String)field2.getBody());
        Assert.assertEquals((String)"raw: any", (String)field2.toString());
    }

    @Test
    public void testTabAfterDelimiter() throws Exception {
        String s = "raw:\tstuff;\r\n  more stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField field = new RawField(raw, 3, "raw", null);
        Assert.assertSame((Object)raw, (Object)field.getRaw());
        Assert.assertEquals((String)"raw", (String)field.getName());
        Assert.assertEquals((String)"stuff;  more stuff", (String)field.getBody());
        Assert.assertEquals((String)s, (String)field.toString());
    }

    @Test
    public void shouldRejectAmbiguousLineEnding() {
        AssertionsForClassTypes.assertThatThrownBy(() -> new RawField("Name", "Value\r\ncheating")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldAcceptCRLFTerminatedHeader() {
        AssertionsForClassTypes.assertThatCode(() -> new RawField("Name", "Value\r\n")).doesNotThrowAnyException();
    }

    @Test
    public void shouldAcceptTabFolding() {
        AssertionsForClassTypes.assertThatCode(() -> new RawField("Name", "Value\r\n\thello")).doesNotThrowAnyException();
    }

    @Test
    public void shouldAcceptSpaceFolding() {
        AssertionsForClassTypes.assertThatCode(() -> new RawField("Name", "Value\r\n hello")).doesNotThrowAnyException();
    }

    @Test
    public void shouldAcceptOnlyDelimiter() {
        AssertionsForClassTypes.assertThatCode(() -> new RawField("Name", "\r\n")).doesNotThrowAnyException();
    }

    @Test
    public void shouldAcceptNoDelimiter() {
        AssertionsForClassTypes.assertThatCode(() -> new RawField("Name", "Value")).doesNotThrowAnyException();
    }
}

