/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.io.LineNumberInputStream;
import org.junit.Assert;
import org.junit.Test;

public class LineNumberInputStreamTest {
    @Test
    public void testReadSingleByte() throws IOException {
        int i;
        String s = "Yada\r\nyada\r\nyada\r\n";
        LineNumberInputStream is = new LineNumberInputStream(InputStreams.createAscii((CharSequence)s));
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((long)1L, (long)is.getLineNumber());
            is.read();
        }
        for (i = 6; i < 12; ++i) {
            Assert.assertEquals((long)2L, (long)is.getLineNumber());
            is.read();
        }
        for (i = 12; i < 18; ++i) {
            Assert.assertEquals((long)3L, (long)is.getLineNumber());
            is.read();
        }
        Assert.assertEquals((long)4L, (long)is.getLineNumber());
        Assert.assertEquals((long)-1L, (long)is.read());
        is.close();
    }

    @Test
    public void testReadManyBytes() throws IOException {
        String s = "Yada\r\nyada\r\nyada\r\n";
        LineNumberInputStream is = new LineNumberInputStream(InputStreams.createAscii((CharSequence)s));
        byte[] buf = new byte[4];
        Assert.assertEquals((long)1L, (long)is.getLineNumber());
        is.read(buf);
        Assert.assertEquals((long)1L, (long)is.getLineNumber());
        is.read(buf);
        Assert.assertEquals((long)2L, (long)is.getLineNumber());
        is.read(buf);
        Assert.assertEquals((long)3L, (long)is.getLineNumber());
        is.read(buf);
        Assert.assertEquals((long)3L, (long)is.getLineNumber());
        is.read(buf);
        Assert.assertEquals((long)4L, (long)is.getLineNumber());
        Assert.assertEquals((long)-1L, (long)is.read());
        is.close();
    }
}

