/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.jmap.draft.methods.ValidationResult;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.OldKeyword;

@JsonDeserialize(builder=Builder.class)
public class UpdateMessagePatch {
    private final Optional<List<String>> mailboxIds;
    private final Optional<Keywords> keywords;
    private final Optional<OldKeyword> oldKeywords;
    private final ImmutableList<ValidationResult> validationErrors;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    UpdateMessagePatch(Optional<List<String>> mailboxIds, Optional<Keywords> keywords, Optional<OldKeyword> oldKeywords, ImmutableList<ValidationResult> validationResults) {
        this.mailboxIds = mailboxIds;
        this.keywords = keywords;
        this.oldKeywords = oldKeywords;
        this.validationErrors = validationResults;
    }

    public Optional<List<String>> getMailboxIds() {
        return this.mailboxIds;
    }

    public boolean isFlagsIdentity() {
        return !this.oldKeywords.isPresent() && !this.keywords.isPresent();
    }

    public boolean isOnlyAFlagUpdate() {
        return !this.mailboxIds.isPresent() && (this.oldKeywords.isPresent() || this.keywords.isPresent());
    }

    public boolean isOnlyAMove() {
        return this.mailboxIds.map(list -> list.size() == 1).orElse(false) != false && this.oldKeywords.isEmpty() && this.keywords.isEmpty();
    }

    public ImmutableList<ValidationResult> getValidationErrors() {
        return this.validationErrors;
    }

    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    public Flags applyToState(Flags currentFlags) {
        return this.oldKeywords.map(oldKeyword -> oldKeyword.applyToState(currentFlags)).orElse(this.keywords.map(keyword -> keyword.asFlagsWithRecentAndDeletedFrom(currentFlags)).orElse(currentFlags));
    }

    public final boolean equals(Object o) {
        if (o instanceof UpdateMessagePatch) {
            UpdateMessagePatch that = (UpdateMessagePatch)o;
            return Objects.equals(this.mailboxIds, that.mailboxIds) && Objects.equals(this.keywords, that.keywords) && Objects.equals(this.oldKeywords, that.oldKeywords) && Objects.equals(this.validationErrors, that.validationErrors);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxIds, this.keywords, this.oldKeywords, this.validationErrors);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxIds", this.mailboxIds).add("keywords", this.keywords).add("oldKeywords", this.oldKeywords).add("validationErrors", this.validationErrors).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<List<String>> mailboxIds = Optional.empty();
        private OldKeyword.Builder oldKeyworkBuilder = OldKeyword.builder();
        private Optional<Map<String, Boolean>> keywords = Optional.empty();
        private Set<ValidationResult> validationResult = Sets.newHashSet();

        public Builder mailboxIds(List<String> mailboxIds) {
            this.mailboxIds = Optional.of(ImmutableList.copyOf(mailboxIds));
            return this;
        }

        public Builder keywords(Map<String, Boolean> keywords) {
            this.keywords = Optional.of(ImmutableMap.copyOf(keywords));
            return this;
        }

        public Builder isFlagged(Boolean isFlagged) {
            this.oldKeyworkBuilder.isFlagged(isFlagged);
            return this;
        }

        public Builder isUnread(Boolean isUnread) {
            this.oldKeyworkBuilder.isUnread(isUnread);
            return this;
        }

        public Builder isAnswered(Boolean isAnswered) {
            this.oldKeyworkBuilder.isAnswered(isAnswered);
            return this;
        }

        public Builder isDraft(Boolean isDraft) {
            this.oldKeyworkBuilder.isDraft(isDraft);
            return this;
        }

        public Builder isForwarded(Boolean isForwarded) {
            this.oldKeyworkBuilder.isForwarded(isForwarded);
            return this;
        }

        public Builder validationResult(Set<ValidationResult> validationResult) {
            this.validationResult.addAll(validationResult);
            return this;
        }

        public UpdateMessagePatch build() {
            if (this.mailboxIds.isPresent() && this.mailboxIds.get().isEmpty()) {
                this.validationResult((Set<ValidationResult>)ImmutableSet.of((Object)ValidationResult.builder().property("mailboxIds").message("mailboxIds property is not supposed to be empty").build()));
            }
            Optional<Keywords> mayBeKeywords = this.creationKeywords();
            Optional<OldKeyword> oldKeywords = this.oldKeyworkBuilder.computeOldKeyword();
            Preconditions.checkArgument((!mayBeKeywords.isPresent() || !oldKeywords.isPresent() ? 1 : 0) != 0, (Object)"Does not support keyword and is* at the same time");
            return new UpdateMessagePatch(this.mailboxIds, mayBeKeywords, oldKeywords, (ImmutableList<ValidationResult>)ImmutableList.copyOf(this.validationResult));
        }

        private Optional<Keywords> creationKeywords() {
            return this.keywords.map(map -> Keywords.strictFactory().fromMap((Map<String, Boolean>)map));
        }
    }
}

