/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.suggest.BitsProducer;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.search.suggest.document.ContextQuery;

public abstract class CompletionQuery
extends Query {
    private final Term term;
    private final BitsProducer filter;

    protected CompletionQuery(Term term, BitsProducer filter) {
        this.validate(term.text());
        this.term = term;
        this.filter = filter;
    }

    public BitsProducer getFilter() {
        return this.filter;
    }

    public String getField() {
        return this.term.field();
    }

    public Term getTerm() {
        return this.term;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        byte type = 0;
        boolean first = true;
        for (LeafReaderContext context : reader.leaves()) {
            Terms terms;
            LeafReader leafReader = context.reader();
            try {
                terms = leafReader.terms(this.getField());
                if (terms == null) {
                }
            }
            catch (IOException e) {}
            continue;
            if (!(terms instanceof CompletionTerms)) continue;
            CompletionTerms completionTerms = (CompletionTerms)terms;
            byte t = completionTerms.getType();
            if (first) {
                type = t;
                first = false;
                continue;
            }
            if (type == t) continue;
            throw new IllegalStateException(this.getField() + " has values of multiple types");
        }
        if (!first) {
            if (this instanceof ContextQuery) {
                if (type == 0) {
                    throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " can not be executed against a non context-enabled SuggestField: " + this.getField());
                }
            } else if (type == 1) {
                return new ContextQuery(this);
            }
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('*');
        if (this.filter != null) {
            buffer.append(",");
            buffer.append("filter");
            buffer.append(":");
            buffer.append(this.filter.toString());
        }
        return buffer.toString();
    }

    private void validate(String termText) {
        for (int i = 0; i < termText.length(); ++i) {
            switch (termText.charAt(i)) {
                case '\u001e': {
                    throw new IllegalArgumentException("Term text cannot contain HOLE character U+001E; this character is reserved");
                }
                case '\u001f': {
                    throw new IllegalArgumentException("Term text cannot contain unit separator character U+001F; this character is reserved");
                }
            }
        }
    }
}

