/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.ml.datafeed.ChunkingConfig;
import org.elasticsearch.client.ml.datafeed.DelayedDataCheckConfig;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class DatafeedConfig
implements ToXContentObject {
    public static final ParseField ID = new ParseField("datafeed_id", new String[0]);
    public static final ParseField QUERY_DELAY = new ParseField("query_delay", new String[0]);
    public static final ParseField FREQUENCY = new ParseField("frequency", new String[0]);
    public static final ParseField INDEXES = new ParseField("indexes", new String[0]);
    public static final ParseField INDICES = new ParseField("indices", new String[0]);
    public static final ParseField QUERY = new ParseField("query", new String[0]);
    public static final ParseField SCROLL_SIZE = new ParseField("scroll_size", new String[0]);
    public static final ParseField AGGREGATIONS = new ParseField("aggregations", new String[0]);
    public static final ParseField SCRIPT_FIELDS = new ParseField("script_fields", new String[0]);
    public static final ParseField CHUNKING_CONFIG = new ParseField("chunking_config", new String[0]);
    public static final ParseField DELAYED_DATA_CHECK_CONFIG = new ParseField("delayed_data_check_config", new String[0]);
    public static final ParseField MAX_EMPTY_SEARCHES = new ParseField("max_empty_searches", new String[0]);
    public static final ParseField INDICES_OPTIONS = new ParseField("indices_options", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> PARSER = new ConstructingObjectParser("datafeed_config", true, a -> new Builder((String)a[0], (String)a[1]));
    private final String id;
    private final String jobId;
    private final TimeValue queryDelay;
    private final TimeValue frequency;
    private final List<String> indices;
    private final BytesReference query;
    private final BytesReference aggregations;
    private final List<SearchSourceBuilder.ScriptField> scriptFields;
    private final Integer scrollSize;
    private final ChunkingConfig chunkingConfig;
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final Integer maxEmptySearches;
    private final IndicesOptions indicesOptions;

    private static BytesReference parseBytes(XContentParser parser) throws IOException {
        XContentBuilder contentBuilder = JsonXContent.contentBuilder();
        contentBuilder.generator().copyCurrentStructure(parser);
        return BytesReference.bytes((XContentBuilder)contentBuilder);
    }

    private DatafeedConfig(String id, String jobId, TimeValue queryDelay, TimeValue frequency, List<String> indices, BytesReference query, BytesReference aggregations, List<SearchSourceBuilder.ScriptField> scriptFields, Integer scrollSize, ChunkingConfig chunkingConfig, DelayedDataCheckConfig delayedDataCheckConfig, Integer maxEmptySearches, IndicesOptions indicesOptions) {
        this.id = id;
        this.jobId = jobId;
        this.queryDelay = queryDelay;
        this.frequency = frequency;
        this.indices = indices == null ? null : Collections.unmodifiableList(indices);
        this.query = query;
        this.aggregations = aggregations;
        this.scriptFields = scriptFields == null ? null : Collections.unmodifiableList(scriptFields);
        this.scrollSize = scrollSize;
        this.chunkingConfig = chunkingConfig;
        this.delayedDataCheckConfig = delayedDataCheckConfig;
        this.maxEmptySearches = maxEmptySearches;
        this.indicesOptions = indicesOptions;
    }

    public String getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public TimeValue getQueryDelay() {
        return this.queryDelay;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public List<String> getIndices() {
        return this.indices;
    }

    public Integer getScrollSize() {
        return this.scrollSize;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    public BytesReference getAggregations() {
        return this.aggregations;
    }

    public List<SearchSourceBuilder.ScriptField> getScriptFields() {
        return this.scriptFields == null ? Collections.emptyList() : this.scriptFields;
    }

    public ChunkingConfig getChunkingConfig() {
        return this.chunkingConfig;
    }

    public DelayedDataCheckConfig getDelayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public Integer getMaxEmptySearches() {
        return this.maxEmptySearches;
    }

    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.queryDelay != null) {
            builder.field(QUERY_DELAY.getPreferredName(), this.queryDelay.getStringRep());
        }
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.indices != null) {
            builder.field(INDICES.getPreferredName(), this.indices);
        }
        if (this.query != null) {
            builder.field(QUERY.getPreferredName(), DatafeedConfig.asMap(this.query));
        }
        if (this.aggregations != null) {
            builder.field(AGGREGATIONS.getPreferredName(), DatafeedConfig.asMap(this.aggregations));
        }
        if (this.scriptFields != null) {
            builder.startObject(SCRIPT_FIELDS.getPreferredName());
            for (SearchSourceBuilder.ScriptField scriptField : this.scriptFields) {
                scriptField.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.scrollSize != null) {
            builder.field(SCROLL_SIZE.getPreferredName(), this.scrollSize);
        }
        if (this.chunkingConfig != null) {
            builder.field(CHUNKING_CONFIG.getPreferredName(), (ToXContent)this.chunkingConfig);
        }
        if (this.delayedDataCheckConfig != null) {
            builder.field(DELAYED_DATA_CHECK_CONFIG.getPreferredName(), (ToXContent)this.delayedDataCheckConfig);
        }
        if (this.maxEmptySearches != null) {
            builder.field(MAX_EMPTY_SEARCHES.getPreferredName(), this.maxEmptySearches);
        }
        if (this.indicesOptions != null) {
            builder.startObject(INDICES_OPTIONS.getPreferredName());
            this.indicesOptions.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static Map<String, Object> asMap(BytesReference bytesReference) {
        return bytesReference == null ? null : (Map)XContentHelper.convertToMap((BytesReference)bytesReference, (boolean)true, (XContentType)XContentType.JSON).v2();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DatafeedConfig that = (DatafeedConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.queryDelay, that.queryDelay) && Objects.equals(this.indices, that.indices) && Objects.equals(DatafeedConfig.asMap(this.query), DatafeedConfig.asMap(that.query)) && Objects.equals(this.scrollSize, that.scrollSize) && Objects.equals(DatafeedConfig.asMap(this.aggregations), DatafeedConfig.asMap(that.aggregations)) && Objects.equals(this.scriptFields, that.scriptFields) && Objects.equals(this.chunkingConfig, that.chunkingConfig) && Objects.equals(this.delayedDataCheckConfig, that.delayedDataCheckConfig) && Objects.equals(this.maxEmptySearches, that.maxEmptySearches) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId, this.frequency, this.queryDelay, this.indices, DatafeedConfig.asMap(this.query), this.scrollSize, DatafeedConfig.asMap(this.aggregations), this.scriptFields, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches, this.indicesOptions);
    }

    public static Builder builder(String id, String jobId) {
        return new Builder(id, jobId);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareStringArray(Builder::setIndices, INDEXES);
        PARSER.declareStringArray(Builder::setIndices, INDICES);
        PARSER.declareString((builder, val) -> builder.setQueryDelay(TimeValue.parseTimeValue((String)val, (String)QUERY_DELAY.getPreferredName())), QUERY_DELAY);
        PARSER.declareString((builder, val) -> builder.setFrequency(TimeValue.parseTimeValue((String)val, (String)FREQUENCY.getPreferredName())), FREQUENCY);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setQuery(x$0), DatafeedConfig::parseBytes, QUERY, ObjectParser.ValueType.OBJECT);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setAggregations(x$0), DatafeedConfig::parseBytes, AGGREGATIONS, ObjectParser.ValueType.OBJECT);
        PARSER.declareObject(Builder::setScriptFields, (p, c) -> {
            ArrayList<SearchSourceBuilder.ScriptField> parsedScriptFields = new ArrayList<SearchSourceBuilder.ScriptField>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                parsedScriptFields.add(new SearchSourceBuilder.ScriptField(p));
            }
            return parsedScriptFields;
        }, SCRIPT_FIELDS);
        PARSER.declareInt(Builder::setScrollSize, SCROLL_SIZE);
        PARSER.declareObject(Builder::setChunkingConfig, ChunkingConfig.PARSER, CHUNKING_CONFIG);
        PARSER.declareObject(Builder::setDelayedDataCheckConfig, DelayedDataCheckConfig.PARSER, DELAYED_DATA_CHECK_CONFIG);
        PARSER.declareInt(Builder::setMaxEmptySearches, MAX_EMPTY_SEARCHES);
        PARSER.declareObject(Builder::setIndicesOptions, (p, c) -> IndicesOptions.fromMap((Map)p.map(), (IndicesOptions)new IndicesOptions(IndicesOptions.Option.NONE, IndicesOptions.WildcardStates.NONE)), INDICES_OPTIONS);
    }

    public static class Builder {
        private String id;
        private String jobId;
        private TimeValue queryDelay;
        private TimeValue frequency;
        private List<String> indices;
        private BytesReference query;
        private BytesReference aggregations;
        private List<SearchSourceBuilder.ScriptField> scriptFields;
        private Integer scrollSize;
        private ChunkingConfig chunkingConfig;
        private DelayedDataCheckConfig delayedDataCheckConfig;
        private Integer maxEmptySearches;
        private IndicesOptions indicesOptions;

        public Builder(String id, String jobId) {
            this.id = Objects.requireNonNull(id, ID.getPreferredName());
            this.jobId = Objects.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public Builder(DatafeedConfig config) {
            this.id = config.id;
            this.jobId = config.jobId;
            this.queryDelay = config.queryDelay;
            this.frequency = config.frequency;
            this.indices = config.indices == null ? null : new ArrayList(config.indices);
            this.query = config.query;
            this.aggregations = config.aggregations;
            this.scriptFields = config.scriptFields == null ? null : new ArrayList(config.scriptFields);
            this.scrollSize = config.scrollSize;
            this.chunkingConfig = config.chunkingConfig;
            this.delayedDataCheckConfig = config.getDelayedDataCheckConfig();
            this.maxEmptySearches = config.getMaxEmptySearches();
            this.indicesOptions = config.indicesOptions;
        }

        public Builder setIndices(List<String> indices) {
            this.indices = Objects.requireNonNull(indices, INDICES.getPreferredName());
            return this;
        }

        public Builder setIndices(String ... indices) {
            return this.setIndices(Arrays.asList(indices));
        }

        public Builder setQueryDelay(TimeValue queryDelay) {
            this.queryDelay = queryDelay;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        private Builder setQuery(BytesReference query) {
            this.query = query;
            return this;
        }

        public Builder setQuery(String queryAsJson) {
            this.query = queryAsJson == null ? null : new BytesArray(queryAsJson);
            return this;
        }

        public Builder setQuery(QueryBuilder query) throws IOException {
            this.query = query == null ? null : Builder.xContentToBytes((ToXContentObject)query);
            return this;
        }

        private Builder setAggregations(BytesReference aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public Builder setAggregations(String aggsAsJson) {
            this.aggregations = aggsAsJson == null ? null : new BytesArray(aggsAsJson);
            return this;
        }

        public Builder setAggregations(AggregatorFactories.Builder aggregations) throws IOException {
            this.aggregations = aggregations == null ? null : Builder.xContentToBytes((ToXContentObject)aggregations);
            return this;
        }

        public Builder setScriptFields(List<SearchSourceBuilder.ScriptField> scriptFields) {
            ArrayList<SearchSourceBuilder.ScriptField> sorted = new ArrayList<SearchSourceBuilder.ScriptField>(scriptFields);
            sorted.sort(Comparator.comparing(SearchSourceBuilder.ScriptField::fieldName));
            this.scriptFields = sorted;
            return this;
        }

        public Builder setScrollSize(int scrollSize) {
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder setChunkingConfig(ChunkingConfig chunkingConfig) {
            this.chunkingConfig = chunkingConfig;
            return this;
        }

        public Builder setDelayedDataCheckConfig(DelayedDataCheckConfig delayedDataCheckConfig) {
            this.delayedDataCheckConfig = delayedDataCheckConfig;
            return this;
        }

        public Builder setMaxEmptySearches(int maxEmptySearches) {
            this.maxEmptySearches = maxEmptySearches;
            return this;
        }

        public Builder setIndicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public DatafeedConfig build() {
            return new DatafeedConfig(this.id, this.jobId, this.queryDelay, this.frequency, this.indices, this.query, this.aggregations, this.scriptFields, this.scrollSize, this.chunkingConfig, this.delayedDataCheckConfig, this.maxEmptySearches, this.indicesOptions);
        }

        private static BytesReference xContentToBytes(ToXContentObject object) throws IOException {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                object.toXContent(builder, ToXContentObject.EMPTY_PARAMS);
                BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
                return bytesReference;
            }
        }
    }
}

