/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.transform.transforms.pivot.AggregationConfig;
import org.elasticsearch.client.transform.transforms.pivot.GroupConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactories;

public class PivotConfig
implements ToXContentObject {
    private static final ParseField GROUP_BY = new ParseField("group_by", new String[0]);
    private static final ParseField AGGREGATIONS = new ParseField("aggregations", new String[0]);
    private static final ParseField MAX_PAGE_SEARCH_SIZE = new ParseField("max_page_search_size", new String[0]);
    private final GroupConfig groups;
    private final AggregationConfig aggregationConfig;
    private final Integer maxPageSearchSize;
    private static final ConstructingObjectParser<PivotConfig, Void> PARSER = new ConstructingObjectParser("pivot_config", true, args -> new PivotConfig((GroupConfig)args[0], (AggregationConfig)args[1], (Integer)args[2]));

    public static PivotConfig fromXContent(XContentParser parser) {
        return (PivotConfig)PARSER.apply(parser, null);
    }

    PivotConfig(GroupConfig groups, AggregationConfig aggregationConfig, Integer maxPageSearchSize) {
        this.groups = groups;
        this.aggregationConfig = aggregationConfig;
        this.maxPageSearchSize = maxPageSearchSize;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(GROUP_BY.getPreferredName(), (ToXContent)this.groups);
        builder.field(AGGREGATIONS.getPreferredName(), (ToXContent)this.aggregationConfig);
        if (this.maxPageSearchSize != null) {
            builder.field(MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
        }
        builder.endObject();
        return builder;
    }

    public AggregationConfig getAggregationConfig() {
        return this.aggregationConfig;
    }

    public GroupConfig getGroupConfig() {
        return this.groups;
    }

    @Deprecated
    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        PivotConfig that = (PivotConfig)other;
        return Objects.equals(this.groups, that.groups) && Objects.equals(this.aggregationConfig, that.aggregationConfig) && Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.aggregationConfig, this.maxPageSearchSize);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> GroupConfig.fromXContent(p), GROUP_BY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AggregationConfig.fromXContent(p), AGGREGATIONS);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_PAGE_SEARCH_SIZE);
    }

    public static class Builder {
        private GroupConfig groups;
        private AggregationConfig aggregationConfig;
        private Integer maxPageSearchSize;

        public Builder setGroups(GroupConfig groups) {
            this.groups = groups;
            return this;
        }

        public Builder setAggregationConfig(AggregationConfig aggregationConfig) {
            this.aggregationConfig = aggregationConfig;
            return this;
        }

        public Builder setAggregations(AggregatorFactories.Builder aggregations) {
            this.aggregationConfig = new AggregationConfig(aggregations);
            return this;
        }

        @Deprecated
        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize;
            return this;
        }

        public PivotConfig build() {
            return new PivotConfig(this.groups, this.aggregationConfig, this.maxPageSearchSize);
        }
    }
}

