/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.projections;

import javax.inject.Inject;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import reactor.core.publisher.Mono;

public class MessageFastViewProjectionHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("MessageFastViewProjection");
    private static final double MAXIMUM_MISS_PERCENTAGE_ACCEPTED = 10.0;
    private final Metric retrieveHitCountMetric;
    private final Metric retrieveMissCountMetric;

    @Inject
    MessageFastViewProjectionHealthCheck(MetricFactory metricFactory) {
        this.retrieveHitCountMetric = metricFactory.generate("MessageFastViewProjection:retrieveHitCount");
        this.retrieveMissCountMetric = metricFactory.generate("MessageFastViewProjection:retrieveMissCount");
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> ((Metric)this.retrieveMissCountMetric).movingAverage()).flatMap(missCount -> {
            if (missCount == 0.0) {
                return Mono.just((Object)Result.healthy((ComponentName)COMPONENT_NAME));
            }
            return Mono.fromCallable(() -> ((Metric)this.retrieveHitCountMetric).movingAverage()).map(hitCount -> this.check((double)hitCount, (double)missCount));
        });
    }

    private Result check(double hitAverage, double missAverage) {
        double total = hitAverage + missAverage;
        double missPercentage = missAverage * 100.0 / total;
        if (missPercentage > 10.0) {
            return Result.degraded((ComponentName)COMPONENT_NAME, (String)String.format("Miss percentage %.2f%% (%.0f/%.0f) is higher than the threshold %.0f%%", missPercentage, missAverage, total, 10.0));
        }
        return Result.healthy((ComponentName)COMPONENT_NAME);
    }
}

