/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.Limits;
import org.apache.james.mailbox.cassandra.quota.QuotaCodec;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class CassandraPerUserMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setMaxStorageStatement;
    private final PreparedStatement setMaxMessageStatement;
    private final PreparedStatement getMaxStatement;
    private final PreparedStatement removeMaxStorageStatement;
    private final PreparedStatement removeMaxMessageStatement;

    @Inject
    public CassandraPerUserMaxQuotaDao(Session session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.setMaxStorageStatement = session.prepare((RegularStatement)this.setMaxStorageStatement());
        this.setMaxMessageStatement = session.prepare((RegularStatement)this.setMaxMessageStatement());
        this.getMaxStatement = session.prepare((RegularStatement)this.getMaxStatement());
        this.removeMaxStorageStatement = session.prepare((RegularStatement)this.removeMaxStorageStatement());
        this.removeMaxMessageStatement = session.prepare((RegularStatement)this.removeMaxMessageStatement());
    }

    private Delete.Where removeMaxMessageStatement() {
        return QueryBuilder.delete().column("maxMessageCount").from("maxQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker()));
    }

    private Delete.Where removeMaxStorageStatement() {
        return QueryBuilder.delete().column("maxStorage").from("maxQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker()));
    }

    private Select.Where getMaxStatement() {
        return QueryBuilder.select().from("maxQuota").where(QueryBuilder.eq((String)"quotaRoot", (Object)QueryBuilder.bindMarker()));
    }

    private Insert setMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"maxQuota").value("quotaRoot", (Object)QueryBuilder.bindMarker()).value("maxMessageCount", (Object)QueryBuilder.bindMarker());
    }

    private Insert setMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"maxQuota").value("quotaRoot", (Object)QueryBuilder.bindMarker()).value("maxStorage", (Object)QueryBuilder.bindMarker());
    }

    Mono<Void> setMaxStorage(QuotaRoot quotaRoot, QuotaSizeLimit maxStorageQuota) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxStorageStatement.bind(new Object[]{quotaRoot.getValue(), QuotaCodec.quotaValueToLong(maxStorageQuota)}));
    }

    Mono<Void> setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setMaxMessageStatement.bind(new Object[]{quotaRoot.getValue(), QuotaCodec.quotaValueToLong(maxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getMaxStorage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> Optional.ofNullable((Long)row.get("maxStorage", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getMaxMessage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> Optional.ofNullable((Long)row.get("maxMessageCount", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Limits> getLimits(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeSingleRow((Statement)this.getMaxStatement.bind(new Object[]{quotaRoot.getValue()})).map(row -> {
            Optional<Long> sizeLimit = Optional.ofNullable((Long)row.get("maxStorage", Long.class));
            Optional<Long> countLimit = Optional.ofNullable((Long)row.get("maxMessageCount", Long.class));
            return new Limits(sizeLimit.flatMap(QuotaCodec::longToQuotaSize), countLimit.flatMap(QuotaCodec::longToQuotaCount));
        }).switchIfEmpty(Mono.just((Object)Limits.empty()));
    }

    Mono<Void> removeMaxMessage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxMessageStatement.bind(new Object[]{quotaRoot.getValue()}));
    }

    Mono<Void> removeMaxStorage(QuotaRoot quotaRoot) {
        return this.queryExecutor.executeVoid((Statement)this.removeMaxStorageStatement.bind(new Object[]{quotaRoot.getValue()}));
    }
}

