/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.elasticsearch.v7.query;

import org.apache.james.mailbox.model.SearchQuery;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class SortConverter {
    private static final String PATH_SEPARATOR = ".";

    public static FieldSortBuilder convertSort(SearchQuery.Sort sort) {
        return ((FieldSortBuilder)SortConverter.getSortClause(sort.getSortClause()).order(SortConverter.getOrder(sort))).sortMode(SortMode.MIN);
    }

    private static FieldSortBuilder getSortClause(SearchQuery.Sort.SortClause clause) {
        switch (clause) {
            case Arrival: {
                return SortBuilders.fieldSort((String)"date");
            }
            case MailboxCc: {
                return SortBuilders.fieldSort((String)"cc.address.raw");
            }
            case MailboxFrom: {
                return SortBuilders.fieldSort((String)"from.address.raw");
            }
            case MailboxTo: {
                return SortBuilders.fieldSort((String)"to.address.raw");
            }
            case BaseSubject: {
                return SortBuilders.fieldSort((String)"subject.raw");
            }
            case Size: {
                return SortBuilders.fieldSort((String)"size");
            }
            case SentDate: {
                return SortBuilders.fieldSort((String)"sentDate");
            }
            case Uid: {
                return SortBuilders.fieldSort((String)"uid");
            }
            case Id: {
                return SortBuilders.fieldSort((String)"messageId");
            }
        }
        throw new RuntimeException("Sort is not implemented");
    }

    private static SortOrder getOrder(SearchQuery.Sort sort) {
        if (sort.isReverse()) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }
}

