/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.netty;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.pop3server.netty.POP3Server;
import org.apache.james.protocols.lib.handler.ProtocolHandlerLoader;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.lib.netty.AbstractServerFactory;
import org.jboss.netty.util.HashedWheelTimer;

public class POP3ServerFactory
extends AbstractServerFactory {
    private ProtocolHandlerLoader loader;
    private FileSystem fileSystem;
    private HashedWheelTimer hashedWheelTimer;

    @Inject
    public void setProtocolHandlerLoader(ProtocolHandlerLoader loader) {
        this.loader = loader;
    }

    @Inject
    public final void setFileSystem(FileSystem filesystem) {
        this.fileSystem = filesystem;
    }

    @Inject
    public void setHashedWheelTimer(HashedWheelTimer hashedWheelTimer) {
        this.hashedWheelTimer = hashedWheelTimer;
    }

    protected POP3Server createServer() {
        return new POP3Server();
    }

    protected List<AbstractConfigurableAsyncServer> createServers(HierarchicalConfiguration<ImmutableNode> config) throws Exception {
        ArrayList<AbstractConfigurableAsyncServer> servers = new ArrayList<AbstractConfigurableAsyncServer>();
        List configs = config.configurationsAt("pop3server");
        for (HierarchicalConfiguration serverConfig : configs) {
            POP3Server server = this.createServer();
            server.setProtocolHandlerLoader(this.loader);
            server.setFileSystem(this.fileSystem);
            server.setHashWheelTimer(this.hashedWheelTimer);
            server.configure(serverConfig);
            servers.add((AbstractConfigurableAsyncServer)server);
        }
        return servers;
    }
}

