/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.AutoDetectedDomainRemovalException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.lib.EnvDetector;
import org.apache.james.lifecycle.api.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainList
implements DomainList,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDomainList.class);
    public static final String ENV_DOMAIN = "DOMAIN";
    private final DNSService dns;
    private final EnvDetector envDetector;
    private LoadingCache<Domain, Boolean> cache;
    private DomainListConfiguration configuration;
    private Domain defaultDomain;

    public AbstractDomainList(DNSService dns, EnvDetector envDetector) {
        this.dns = dns;
        this.envDetector = envDetector;
    }

    public AbstractDomainList(DNSService dns) {
        this(dns, new EnvDetector());
    }

    public void configure(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        DomainListConfiguration domainListConfiguration = DomainListConfiguration.from(config);
        this.configure(domainListConfiguration);
    }

    public void configure(DomainListConfiguration domainListConfiguration) throws ConfigurationException {
        this.configuration = domainListConfiguration;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(this.configuration.getCacheExpiracy()).build((CacheLoader)new CacheLoader<Domain, Boolean>(){

            public Boolean load(Domain key) throws DomainListException {
                return AbstractDomainList.this.containsDomainInternal(key) || AbstractDomainList.this.detectedDomainsContains(key);
            }
        });
        this.configureDefaultDomain(domainListConfiguration.getDefaultDomain());
        this.addEnvDomain();
        this.addConfiguredDomains(domainListConfiguration.getConfiguredDomains());
    }

    public void configure(DomainListConfiguration.Builder configurationBuilder) throws ConfigurationException {
        this.configure(configurationBuilder.build());
    }

    protected void addConfiguredDomains(List<Domain> domains) {
        domains.stream().filter(Throwing.predicate(domain -> !this.containsDomainInternal((Domain)domain)).sneakyThrow()).forEach(Throwing.consumer(arg_0 -> ((AbstractDomainList)this).addDomain(arg_0)).sneakyThrow());
    }

    private void addEnvDomain() {
        String envDomain = this.envDetector.getEnv(ENV_DOMAIN);
        if (!Strings.isNullOrEmpty((String)envDomain)) {
            try {
                LOGGER.info("Adding environment defined domain {}", (Object)envDomain);
                this.addDomain(Domain.of((String)envDomain));
            }
            catch (DomainListException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @VisibleForTesting
    void configureDefaultDomain(Domain defaultDomain) throws ConfigurationException {
        try {
            this.setDefaultDomain(defaultDomain);
            String hostName = InetAddress.getLocalHost().getHostName();
            if (this.mayChangeDefaultDomain()) {
                this.setDefaultDomain(Domain.of((String)hostName));
            }
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to retrieve hostname.", (Throwable)e);
        }
        catch (DomainListException e) {
            LOGGER.error("An error occured while creating the default domain", (Throwable)e);
        }
    }

    private boolean mayChangeDefaultDomain() {
        return this.configuration.isAutoDetect() && Domain.LOCALHOST.equals((Object)this.defaultDomain);
    }

    private void setDefaultDomain(Domain defaultDomain) throws DomainListException {
        if (defaultDomain != null && !this.containsDomain(defaultDomain)) {
            this.addDomain(defaultDomain);
        }
        this.defaultDomain = defaultDomain;
    }

    public Domain getDefaultDomain() throws DomainListException {
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        throw new DomainListException("Null default domain. Domain list might not be configured yet.");
    }

    public boolean containsDomain(Domain domain) throws DomainListException {
        if (this.configuration.isCacheEnabled()) {
            try {
                return (Boolean)this.cache.get((Object)domain);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof DomainListException) {
                    throw (DomainListException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
        boolean internalAnswer = this.containsDomainInternal(domain);
        return internalAnswer || this.detectedDomainsContains(domain);
    }

    private boolean detectedDomainsContains(Domain domain) throws DomainListException {
        if (this.configuration.isAutoDetect() || this.configuration.isAutoDetectIp()) {
            return this.getDomains().contains((Object)domain);
        }
        return false;
    }

    public ImmutableList<Domain> getDomains() throws DomainListException {
        Multimap<DomainType, Domain> domainsWithType = this.getDomainsWithType();
        ImmutableSet allDomains = (ImmutableSet)domainsWithType.values().stream().collect(ImmutableSet.toImmutableSet());
        if (this.configuration.isCacheEnabled()) {
            domainsWithType.get((Object)DomainType.Internal).forEach(domain -> this.cache.put(domain, (Object)true));
        }
        if (LOGGER.isDebugEnabled()) {
            for (Domain domain2 : allDomains) {
                LOGGER.debug("Handling mail for: " + domain2.name());
            }
        }
        return ImmutableList.copyOf((Collection)allDomains);
    }

    private Multimap<DomainType, Domain> getDomainsWithType() throws DomainListException {
        List<Domain> domains = this.getDomainListInternal();
        ImmutableList<Domain> detectedDomains = this.detectDomains();
        ImmutableList domainsWithoutIp = ImmutableList.builder().addAll(domains).addAll(detectedDomains).build();
        ImmutableList<Domain> ips = this.detectIps((Collection<Domain>)domainsWithoutIp);
        ImmutableMultimap.Builder result = ImmutableMultimap.builder().putAll((Object)DomainType.Internal, domains).putAll((Object)DomainType.Detected, detectedDomains).putAll((Object)DomainType.DetectedIp, ips);
        Optional.ofNullable(this.defaultDomain).ifPresent(domain -> result.put((Object)DomainType.DefaultDomain, domain));
        return result.build();
    }

    private ImmutableList<Domain> detectIps(Collection<Domain> domains) {
        if (this.configuration.isAutoDetectIp()) {
            return (ImmutableList)AbstractDomainList.getDomainsIpStream(domains, this.dns, LOGGER).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }

    private ImmutableList<Domain> detectDomains() {
        if (this.configuration.isAutoDetect()) {
            String hostName;
            try {
                hostName = this.removeTrailingDot(this.dns.getHostName(this.dns.getLocalHost()));
            }
            catch (UnknownHostException ue) {
                hostName = "localhost";
            }
            LOGGER.info("Local host is: {}", (Object)hostName);
            if (!Strings.isNullOrEmpty((String)hostName) && !hostName.equals("localhost")) {
                return ImmutableList.of((Object)Domain.of((String)hostName));
            }
        }
        return ImmutableList.of();
    }

    private String removeTrailingDot(String domain) {
        if (domain != null && domain.endsWith(".")) {
            return domain.substring(0, domain.length() - 1);
        }
        return domain;
    }

    private static Stream<Domain> getDomainsIpStream(Collection<Domain> domains, DNSService dns, Logger log) {
        return domains.stream().flatMap(domain -> AbstractDomainList.getDomainIpStream(domain, dns, log)).distinct();
    }

    private static Stream<Domain> getDomainIpStream(Domain domain, DNSService dns, Logger log) {
        try {
            return dns.getAllByName(domain.name()).stream().map(InetAddress::getHostAddress).map(Domain::of).distinct();
        }
        catch (UnknownHostException e) {
            log.error("Cannot get IP address(es) for {}", (Object)domain);
            return Stream.of(new Domain[0]);
        }
    }

    public void removeDomain(Domain domain) throws DomainListException {
        if (this.isAutoDetected(domain)) {
            throw new AutoDetectedDomainRemovalException(domain);
        }
        this.doRemoveDomain(domain);
    }

    private boolean isAutoDetected(Domain domain) throws DomainListException {
        Multimap<DomainType, Domain> domainsWithType = this.getDomainsWithType();
        return domainsWithType.get((Object)DomainType.Detected).contains(domain) || domainsWithType.get((Object)DomainType.DetectedIp).contains(domain) || domainsWithType.get((Object)DomainType.DefaultDomain).contains(domain);
    }

    protected abstract List<Domain> getDomainListInternal() throws DomainListException;

    protected abstract boolean containsDomainInternal(Domain var1) throws DomainListException;

    protected abstract void doRemoveDomain(Domain var1) throws DomainListException;

    static enum DomainType {
        DefaultDomain,
        Internal,
        Detected,
        DetectedIp;

    }
}

