/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.transport.KeyStoreHolder;
import org.apache.james.transport.SMIMESignerInfo;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMECheckSignature
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMIMECheckSignature.class);
    private KeyStoreHolder trustedCertificateStore;
    private boolean stripSignature = false;
    private boolean onlyTrusted = true;
    private AttributeName mailAttribute = AttributeName.of("org.apache.james.SMIMECheckSignature");

    @Override
    public void init() throws MessagingException {
        String mailAttributeConf;
        String onlyTrustedConf;
        MailetConfig config = this.getMailetConfig();
        String stripSignatureConf = config.getInitParameter("strip");
        if (stripSignatureConf != null) {
            this.stripSignature = Boolean.parseBoolean(stripSignatureConf);
        }
        if ((onlyTrustedConf = config.getInitParameter("onlyTrusted")) != null) {
            this.onlyTrusted = Boolean.parseBoolean(onlyTrustedConf);
        }
        if ((mailAttributeConf = config.getInitParameter("mailAttribute")) != null) {
            this.mailAttribute = AttributeName.of(mailAttributeConf);
        }
        String type = config.getInitParameter("keyStoreType");
        String file = config.getInitParameter("keyStoreFileName");
        String password = config.getInitParameter("keyStorePassword");
        try {
            if (file != null) {
                this.trustedCertificateStore = new KeyStoreHolder(file, password, type);
            } else {
                LOGGER.info("No trusted store path specified, using default store.");
                this.trustedCertificateStore = new KeyStoreHolder(password);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Error loading the trusted certificate store", e);
        }
    }

    @Override
    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        MimeBodyPart strippedMessage = null;
        List<SMIMESignerInfo> signers = null;
        try {
            SMIMESigned signed = this.asSMIMESigned(message);
            if (signed != null) {
                signers = this.trustedCertificateStore.verifySignatures(signed);
                strippedMessage = signed.getContent();
            } else {
                LOGGER.info("Content not identified as signed");
            }
        }
        catch (CMSException | SMIMEException e) {
            LOGGER.error("Error during the analysis of the signed message", e);
            signers = null;
        }
        catch (IOException e) {
            LOGGER.error("IO error during the analysis of the signed message", e);
            signers = null;
        }
        catch (Exception e) {
            LOGGER.error("Generic error occured during the analysis of the message", e);
            signers = null;
        }
        if (signers != null) {
            ArrayList<AttributeValue<?>> signerinfolist = this.signerInfoList(signers);
            if (!signerinfolist.isEmpty()) {
                mail.setAttribute(new Attribute(this.mailAttribute, AttributeValue.of(signerinfolist)));
            } else {
                strippedMessage = null;
            }
        }
        if (this.stripSignature && strippedMessage != null) {
            this.stripSignature(mail, message, strippedMessage);
        }
    }

    private ArrayList<AttributeValue<?>> signerInfoList(List<SMIMESignerInfo> signers) {
        ArrayList signerinfolist = new ArrayList();
        for (SMIMESignerInfo info : signers) {
            if (!info.isSignValid() || this.onlyTrusted && info.getCertPath() == null) continue;
            try {
                signerinfolist.add(AttributeValue.of(info.getSignerCertificate().getEncoded()));
            }
            catch (CertificateEncodingException e) {
                LOGGER.warn("Failed to encode certificate", e);
            }
        }
        return signerinfolist;
    }

    private void stripSignature(Mail mail, MimeMessage message, MimeBodyPart strippedMessage) throws MessagingException {
        try {
            Object obj = strippedMessage.getContent();
            if (obj instanceof Multipart) {
                message.setContent((Multipart)obj);
            } else {
                message.setContent(obj, strippedMessage.getContentType());
            }
            message.saveChanges();
            mail.setMessage(message);
        }
        catch (Exception e) {
            throw new MessagingException("Error during the extraction of the signed content from the message.", e);
        }
    }

    private SMIMESigned asSMIMESigned(MimeMessage message) throws IOException, MessagingException, CMSException, SMIMEException {
        Object obj = message.getContent();
        SMIMESigned signed = obj instanceof MimeMultipart ? new SMIMESigned((MimeMultipart)message.getContent()) : (obj instanceof SMIMESigned ? (SMIMESigned)obj : (obj instanceof byte[] ? new SMIMESigned(message) : null));
        return signed;
    }
}

