/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.concurrent.ThreadLocalRandom;

public class Port {
    public static final int MAX_PORT_VALUE = 65535;
    public static final int PRIVILEGED_PORT_BOUND = 1024;
    private static final Range<Integer> VALID_PORT_RANGE = Range.closed(1, 65535);
    private final int value;

    public static Port of(int portNumber) {
        return new Port(portNumber);
    }

    public static int generateValidUnprivilegedPort() {
        return ThreadLocalRandom.current().nextInt(64511) + 1024;
    }

    public static void assertValid(int port) {
        Preconditions.checkArgument(Port.isValid(port), "Port should be between 1 and 65535");
    }

    public static boolean isValid(int port) {
        return VALID_PORT_RANGE.contains(port);
    }

    public Port(int value) {
        this.validate(value);
        this.value = value;
    }

    protected void validate(int port) {
        Port.assertValid(port);
    }

    public int getValue() {
        return this.value;
    }
}

