/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MetadataWithMailboxId;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageConverter;
import org.apache.james.vault.DeletedMessageVault;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;

public class DeletedMessageVaultHook
implements PreDeletionHook {
    private static final int CONCURRENCY = 8;
    private final MailboxSession session;
    private final DeletedMessageVault deletedMessageVault;
    private final DeletedMessageConverter deletedMessageConverter;
    private final MailboxSessionMapperFactory mapperFactory;
    private final Clock clock;

    @Inject
    DeletedMessageVaultHook(SessionProvider sessionProvider, DeletedMessageVault deletedMessageVault, DeletedMessageConverter deletedMessageConverter, MailboxSessionMapperFactory mapperFactory, Clock clock) {
        this.session = sessionProvider.createSystemSession(Username.of((String)this.getClass().getName()));
        this.deletedMessageVault = deletedMessageVault;
        this.deletedMessageConverter = deletedMessageConverter;
        this.mapperFactory = mapperFactory;
        this.clock = clock;
    }

    public Publisher<Void> notifyDelete(PreDeletionHook.DeleteOperation deleteOperation) {
        Preconditions.checkNotNull((Object)deleteOperation);
        return this.groupMetadataByOwnerAndMessageId(deleteOperation).flatMap(this::appendToTheVault, 8).then();
    }

    private Mono<Void> appendToTheVault(DeletedMessageMailboxContext deletedMessageMailboxContext) {
        return this.mapperFactory.getMessageIdMapper(this.session).findReactive((Collection)ImmutableList.of((Object)deletedMessageMailboxContext.getMessageId()), MessageMapper.FetchType.FULL).next().switchIfEmpty(Mono.error(() -> new RuntimeException("Cannot find " + deletedMessageMailboxContext.getMessageId()))).flatMap(mailboxMessage -> Mono.fromCallable(() -> Pair.of((Object)mailboxMessage, (Object)this.deletedMessageConverter.convert(deletedMessageMailboxContext, (Message)mailboxMessage, ZonedDateTime.ofInstant(this.clock.instant(), ZoneOffset.UTC))))).flatMap(pairs -> Mono.fromCallable(() -> ((MailboxMessage)pairs.getLeft()).getFullContent()).flatMap(fullContent -> Mono.from(this.deletedMessageVault.append((DeletedMessage)pairs.getRight(), (InputStream)fullContent))));
    }

    private Flux<DeletedMessageMailboxContext> groupMetadataByOwnerAndMessageId(PreDeletionHook.DeleteOperation deleteOperation) {
        return Flux.fromIterable((Iterable)deleteOperation.getDeletionMetadataList()).groupBy(MetadataWithMailboxId::getMailboxId).flatMap(this::addOwnerToMetadata, 8);
    }

    private Flux<DeletedMessageMailboxContext> addOwnerToMetadata(GroupedFlux<MailboxId, MetadataWithMailboxId> groupedFlux) {
        return this.retrieveMailboxUser((MailboxId)groupedFlux.key()).flatMapMany(owner -> groupedFlux.map(metadata -> new DeletedMessageMailboxContext(metadata.getMessageId(), (Username)owner, (List<MailboxId>)ImmutableList.of((Object)metadata.getMailboxId()))));
    }

    private Mono<Username> retrieveMailboxUser(MailboxId mailboxId) {
        return this.mapperFactory.getMailboxMapper(this.session).findMailboxById(mailboxId).map(Mailbox::getUser);
    }

    static class DeletedMessageMailboxContext {
        private final MessageId messageId;
        private final Username owner;
        private final List<MailboxId> ownerMailboxes;

        DeletedMessageMailboxContext(MessageId messageId, Username owner, List<MailboxId> ownerMailboxes) {
            this.messageId = messageId;
            this.owner = owner;
            this.ownerMailboxes = ownerMailboxes;
        }

        MessageId getMessageId() {
            return this.messageId;
        }

        Username getOwner() {
            return this.owner;
        }

        List<MailboxId> getOwnerMailboxes() {
            return this.ownerMailboxes;
        }

        public final boolean equals(Object o) {
            if (o instanceof DeletedMessageMailboxContext) {
                DeletedMessageMailboxContext that = (DeletedMessageMailboxContext)o;
                return Objects.equals(this.messageId, that.getMessageId()) && Objects.equals(this.owner, that.getOwner()) && Objects.equals(this.ownerMailboxes, that.getOwnerMailboxes());
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.messageId, this.owner, this.ownerMailboxes);
        }
    }
}

